/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;
import panther.util.general.ProportionalBox;

public class ProportionalLayoutManager
implements LayoutManager2 {
    protected Map dimensionsMap = new HashMap();

    public void addLayoutComponent(Component component, Object object) {
        this.dimensionsMap.put(component, object);
    }

    public Dimension maximumLayoutSize(Container container) {
        int n = 5000;
        int n2 = 5000;
        for (Map.Entry entry : this.dimensionsMap.entrySet()) {
            Component component = (Component)entry.getKey();
            Dimension dimension = component.getMaximumSize();
            ProportionalBox proportionalBox = (ProportionalBox)entry.getValue();
            n = Math.min(n, proportionalBox.getTotalWidth(dimension.width));
            n2 = Math.min(n2, proportionalBox.getTotalHeight(dimension.height));
        }
        return new Dimension(n, n2);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        this.dimensionsMap.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this.maximumLayoutSize(container);
        Dimension dimension2 = this.minimumLayoutSize(container);
        return new Dimension((3 * dimension.width + dimension2.width) / 4, (3 * dimension.height + dimension2.height) / 4);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        for (Map.Entry entry : this.dimensionsMap.entrySet()) {
            Component component = (Component)entry.getKey();
            Dimension dimension = component.getMinimumSize();
            ProportionalBox proportionalBox = (ProportionalBox)entry.getValue();
            n = Math.max(n, proportionalBox.getTotalWidth(dimension.width));
            n2 = Math.max(n2, proportionalBox.getTotalHeight(dimension.height));
        }
        return new Dimension(n, n2);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getWidth() - insets.left - insets.right;
        int n2 = container.getHeight() - insets.top - insets.bottom;
        int n3 = insets.left;
        int n4 = insets.top;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ProportionalBox proportionalBox = (ProportionalBox)this.dimensionsMap.get(componentArray[i]);
            int n5 = proportionalBox.getComponentX(n);
            int n6 = proportionalBox.getComponentY(n2);
            int n7 = proportionalBox.getComponentWidth(n);
            int n8 = proportionalBox.getComponentHeight(n2);
            componentArray[i].setBounds(n3 + n5, n4 + n6, n7, n8);
        }
    }
}

