/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.PrintStream;

public class IndentationStream {
    protected PrintStream out;
    protected String indent;
    protected int level;
    protected boolean afterCR = true;

    public IndentationStream(PrintStream printStream, String string, int n) {
        this.out = printStream;
        this.indent = string;
        this.level = n;
    }

    public void close() {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    public void indent() {
        ++this.level;
    }

    public void outdent() {
        this.level = Math.max(0, this.level - 1);
    }

    public void println(Object object) {
        this.println(object.toString());
    }

    public void print(Object object) {
        this.print(object.toString());
    }

    public void println(String string) {
        this.print(string);
        this.outputCR();
    }

    public void print(String string) {
        int n = 0;
        int n2 = string.indexOf("\n");
        while (n2 >= 0) {
            this.output(string.substring(n, n2));
            this.outputCR();
            n = n2 + 1;
            n2 = string.indexOf("\n", n);
        }
        this.output(string.substring(n));
    }

    protected void output(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.afterCR) {
            this.output(this.indent, this.level);
            this.afterCR = false;
        }
        this.out.print(string);
    }

    protected void output(String string, int n) {
        for (int i = 1; i <= n; ++i) {
            this.out.print(string);
        }
    }

    protected void outputCR() {
        this.out.println();
        this.afterCR = true;
    }
}

