/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ErrorUtils {
    private static Logger logger = Logger.getLogger(ErrorUtils.class.getName());

    public static void check(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
    }

    public static void swallow(Throwable throwable) {
        ErrorUtils.swallow(throwable.getMessage(), throwable);
    }

    public static void swallow(String string, Throwable throwable) {
        ErrorUtils.swallow(Level.WARNING, string, throwable);
    }

    public static void checkSwallow(Throwable throwable) {
        ErrorUtils.checkSwallow(Level.WARNING, throwable);
    }

    public static void swallow(Level level, Throwable throwable) {
        ErrorUtils.swallow(level, throwable.getMessage(), throwable);
    }

    public static void swallow(Level level, String string, Throwable throwable) {
        logger.log(level, "<<<<<<<<<<<<<<\nSwallowed Exception: " + string + "\n" + ErrorUtils.stackTrace(throwable) + ">>>>>>>>>>>>\n");
    }

    public static void checkSwallow(Level level, Throwable throwable) {
        ErrorUtils.checkIgnore(throwable);
        ErrorUtils.swallow(level, throwable);
    }

    public static void checkIgnore(String string, Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
    }

    public static void checkIgnore(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
    }

    public static String stackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(2000);
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return ((Object)stringWriter).toString();
    }

    public static String errorString(Throwable throwable) {
        return throwable.getMessage() + ":\n" + ErrorUtils.stackTrace(throwable);
    }

    public static String currentStack() {
        String string = "";
        try {
            throw new Exception("Trace of Current Stack");
        }
        catch (Exception exception) {
            string = ErrorUtils.errorString(exception);
            return string;
        }
    }
}

