/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import panther.util.crypto.DesEdeEncryption;
import panther.util.general.ErrorUtils;
import panther.util.general.StringUtils;

public class EncryptionUtils {
    public static final String SERVER_SEPARATOR = ",";
    public static final String APPLET_SEPARATOR = "||";

    public static String toEncryptedToken(String string) {
        try {
            return EncryptionUtils.encrypt(string);
        }
        catch (Throwable throwable) {
            ErrorUtils.check(throwable);
            return string;
        }
    }

    public static String fromEncryptedToken(String string) {
        try {
            return EncryptionUtils.decrypt(string);
        }
        catch (Throwable throwable) {
            ErrorUtils.check(throwable);
            return string;
        }
    }

    public static byte[] desDecrypt(byte[] byArray) throws Exception {
        DesEdeEncryption desEdeEncryption = new DesEdeEncryption();
        return desEdeEncryption.decrypt(byArray);
    }

    public static String desDecrypt(String string) throws Exception {
        DesEdeEncryption desEdeEncryption = new DesEdeEncryption();
        return desEdeEncryption.decrypt(string);
    }

    public static byte[] desEncrypt(byte[] byArray) throws Exception {
        DesEdeEncryption desEdeEncryption = new DesEdeEncryption();
        return desEdeEncryption.encrypt(byArray);
    }

    public static String desEncrypt(String string) throws Exception {
        DesEdeEncryption desEdeEncryption = new DesEdeEncryption();
        return desEdeEncryption.encrypt(string);
    }

    public static String serverEncrypt(Collection collection) throws Exception {
        return EncryptionUtils.serverEncrypt(collection, SERVER_SEPARATOR);
    }

    public static String serverEncrypt(Collection collection, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(String.valueOf(iterator.next()));
        }
        return EncryptionUtils.encrypt(stringBuffer.toString());
    }

    public static String serverEncryptAndEncode(Collection collection) throws Exception {
        return EncryptionUtils.serverEncryptAndEncode(collection, SERVER_SEPARATOR);
    }

    public static String serverEncryptAndEncode(Collection collection, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(String.valueOf(iterator.next()));
        }
        return EncryptionUtils.encryptAndEncode(stringBuffer.toString());
    }

    public static List serverDecodeAndDecrypt(String string) throws Exception {
        return EncryptionUtils.serverDecodeAndDecrypt(string, SERVER_SEPARATOR);
    }

    public static List serverDecodeAndDecrypt(String string, String string2) throws Exception {
        String string3 = EncryptionUtils.decodeAndDecrypt(string);
        return StringUtils.asTokens(string3, SERVER_SEPARATOR);
    }

    public static List serverDecrypt(String string) throws Exception {
        return EncryptionUtils.serverDecrypt(string, SERVER_SEPARATOR);
    }

    public static List serverDecrypt(String string, String string2) throws Exception {
        String string3 = EncryptionUtils.decrypt(string);
        return StringUtils.asTokens(string3, SERVER_SEPARATOR);
    }

    public static String appletEncryptAndEncode(Collection collection) throws Exception {
        return EncryptionUtils.appletEncryptAndEncode(collection, APPLET_SEPARATOR);
    }

    public static String appletEncryptAndEncode(Collection collection, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(String.valueOf(iterator.next()));
        }
        return EncryptionUtils.appletEncryptAndEncode(stringBuffer.toString());
    }

    public static String appletEncryptAndEncode(String string) throws Exception {
        int n;
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length; n += 2) {
            if (n + 1 >= cArray.length) continue;
            char c = cArray[n];
            cArray[n] = cArray[n + 1];
            cArray[n + 1] = c;
        }
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = (char)((cArray[n] + 1873) % 65535);
        }
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = (char)(cArray[n] ^ 0xA47E);
        }
        return URLEncoder.encode(new String(cArray), "utf-8");
    }

    public static List appletDecodeAndDecrypt(String string) throws Exception {
        return EncryptionUtils.appletDecodeAndDecrypt(string, APPLET_SEPARATOR);
    }

    public static List appletDecodeAndDecrypt(String string, String string2) throws Exception {
        int n;
        String string3 = URLDecoder.decode(string, "utf-8");
        char[] cArray = string3.toCharArray();
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = (char)(cArray[n] ^ 0xA47E);
        }
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] < '\u0751') {
                cArray[n] = (char)(65535 - (1873 - cArray[n]));
                continue;
            }
            int n2 = n;
            cArray[n2] = (char)(cArray[n2] - 1873);
        }
        for (n = 0; n < cArray.length; n += 2) {
            if (n + 1 >= cArray.length) continue;
            char c = cArray[n];
            cArray[n] = cArray[n + 1];
            cArray[n + 1] = c;
        }
        String string4 = new String(cArray);
        return StringUtils.asTokens(string4, string2);
    }

    public static String encryptAndEncode(String string) throws Exception {
        String string2 = EncryptionUtils.encrypt(string);
        return URLEncoder.encode(string2, "utf-8");
    }

    public static String encrypt(String string) throws Exception {
        char[] cArray = string.toCharArray();
        cArray = EncryptionUtils.characterShift(cArray, 311);
        cArray = EncryptionUtils.permute(cArray, 7);
        cArray = EncryptionUtils.positionallyXor(cArray, 17);
        return new String(cArray);
    }

    public static String decodeAndDecrypt(String string) throws Exception {
        String string2 = URLDecoder.decode(string, "utf-8");
        return EncryptionUtils.decrypt(string2);
    }

    public static String decrypt(String string) throws Exception {
        char[] cArray = string.toCharArray();
        cArray = EncryptionUtils.positionallyXor(cArray, 17);
        cArray = EncryptionUtils.permute(cArray, -7);
        cArray = EncryptionUtils.characterUnshift(cArray, 311);
        return new String(cArray);
    }

    protected static char[] positionallyXor(char[] cArray, int n) {
        for (int i = 0; i < cArray.length; ++i) {
            char c = (char)(n * (n + i) % 65535);
            cArray[i] = (char)(cArray[i] ^ c);
        }
        return cArray;
    }

    protected static char[] characterShift(char[] cArray, int n) {
        for (int i = 0; i < cArray.length; ++i) {
            char c;
            cArray[i] = c = (char)((cArray[i] + n) % 65535);
        }
        return cArray;
    }

    protected static char[] permute(char[] cArray, int n) {
        char[] cArray2 = new char[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            int n2 = (i + n) % cArray.length;
            if (n2 < 0) {
                n2 += cArray.length;
            }
            cArray2[i] = cArray[n2];
        }
        return cArray2;
    }

    protected static char[] characterUnshift(char[] cArray, int n) {
        for (int i = 0; i < cArray.length; ++i) {
            char c;
            cArray[i] = c = (char)((cArray[i] - n) % 65535);
        }
        return cArray;
    }
}

