/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import panther.util.general.ArrayUtils;
import panther.util.general.DevOut;
import panther.util.general.IOUtils;
import panther.util.general.OSUtil;
import panther.util.general.OpsOut;
import panther.util.general.StringUtils;
import panther.util.unicon.FileUtil;

public class DiskUtil {
    private static final Map MIME_TYPE_MAP = DiskUtil.initializeMimeTypeMap();
    protected static final String[] APPLICATION_FILE_EXTENSIONS = new String[]{"doc", "pdf", "ppt", "xls"};
    protected static final String[] AUDIO_FILE_EXTENSIONS = new String[]{"aif", "aifc", "aiff", "au", "mid", "midi", "mp2", "mp3", "mpga", "ra", "rpm", "snd", "wav"};
    protected static final String[] FLASH_FILE_EXTENSIONS = new String[]{"swf"};
    protected static final String[] IMAGE_FILE_EXTENSIONS = new String[]{"bmp", "gif", "jpe", "jpeg", "jpg", "png", "tif", "tiff"};
    protected static final String[] VIDEO_FILE_EXTENSIONS = new String[]{"avi", "mov", "mpe", "mpeg", "mpg", "qt", "ram", "rm", "wmv"};

    public static boolean filesDiffer(String string, String string2) throws Exception {
        return DiskUtil.filesDiffer(new File(string), new File(string2));
    }

    public static boolean filesDiffer(File file, File file2) throws Exception {
        if (file.length() != file2.length()) {
            return true;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileInputStream fileInputStream2 = new FileInputStream(file2);
        boolean bl = IOUtils.streamsDiffer(fileInputStream, fileInputStream2);
        ((InputStream)fileInputStream).close();
        ((InputStream)fileInputStream2).close();
        return bl;
    }

    public static String getExtension(File file) {
        return DiskUtil.getExtension(file.getName());
    }

    public static String getExtension(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = StringUtils.substringAfterLast(string, "/");
        String string3 = StringUtils.substringAfterLast(string2, ".");
        return string3;
    }

    public static String getMediaType(String string) {
        return DiskUtil.getMediaTypeFromExtension(DiskUtil.getExtension(string));
    }

    public static String getMediaType(File file) {
        return DiskUtil.getMediaTypeFromExtension(DiskUtil.getExtension(file));
    }

    public static String getMediaTypeFromExtension(String string) {
        if (DiskUtil.isAudioExtension(string)) {
            return "audio";
        }
        if (DiskUtil.isFlashExtension(string)) {
            return "video";
        }
        if (DiskUtil.isImageExtension(string)) {
            return "image";
        }
        if (DiskUtil.isVideoExtension(string)) {
            return "video";
        }
        if (DiskUtil.isApplicationExtension(string)) {
            return "app";
        }
        return null;
    }

    public static String getMimeType(String string) {
        return DiskUtil.getMimeTypeFromExtension(DiskUtil.getExtension(string));
    }

    public static String getMimeType(File file) {
        return DiskUtil.getMimeTypeFromExtension(DiskUtil.getExtension(file));
    }

    public static String getMimeTypeFromExtension(String string) {
        return (String)MIME_TYPE_MAP.get(string);
    }

    public static boolean isApplicationFile(String string) {
        return DiskUtil.isApplicationExtension(DiskUtil.getExtension(string));
    }

    public static boolean isApplicationFile(File file) {
        return DiskUtil.isApplicationExtension(DiskUtil.getExtension(file));
    }

    public static boolean isApplicationExtension(String string) {
        return DiskUtil.extensionIn(string, APPLICATION_FILE_EXTENSIONS);
    }

    public static boolean isAudioFile(String string) {
        return DiskUtil.isAudioExtension(DiskUtil.getExtension(string));
    }

    public static boolean isAudioFile(File file) {
        return DiskUtil.isAudioExtension(DiskUtil.getExtension(file));
    }

    public static boolean isAudioExtension(String string) {
        return DiskUtil.extensionIn(string, AUDIO_FILE_EXTENSIONS);
    }

    public static boolean isFlashFile(String string) {
        return DiskUtil.isFlashExtension(DiskUtil.getExtension(string));
    }

    public static boolean isFlashFile(File file) {
        return DiskUtil.isFlashExtension(DiskUtil.getExtension(file));
    }

    public static boolean isFlashExtension(String string) {
        return DiskUtil.extensionIn(string, FLASH_FILE_EXTENSIONS);
    }

    public static boolean isImageFile(String string) {
        return DiskUtil.isImageExtension(DiskUtil.getExtension(string));
    }

    public static boolean isImageFile(File file) {
        return DiskUtil.isImageExtension(DiskUtil.getExtension(file));
    }

    public static boolean isImageExtension(String string) {
        return DiskUtil.extensionIn(string, IMAGE_FILE_EXTENSIONS);
    }

    public static boolean isVideoFile(String string) {
        return DiskUtil.isVideoExtension(DiskUtil.getExtension(string));
    }

    public static boolean isVideoFile(File file) {
        return DiskUtil.isVideoExtension(DiskUtil.getExtension(file.getName()));
    }

    public static boolean isVideoExtension(String string) {
        return DiskUtil.extensionIn(string, VIDEO_FILE_EXTENSIONS);
    }

    protected static boolean extensionIn(String string, String[] stringArray) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return ArrayUtils.includes(stringArray, string.toLowerCase());
    }

    public static boolean safeWrite(String string, String string2, String string3) {
        boolean bl = false;
        try {
            new File(string2).getParentFile().mkdirs();
            OSUtil.chmod(new File(string2).getParentFile(), "777");
            FileUtil.writeFile(string, string2);
            OSUtil.chmod(string2, string3);
        }
        catch (Exception exception) {
            bl = true;
            OpsOut.println("Error during file copy");
            DevOut.trace(exception);
        }
        return bl;
    }

    public static boolean safeWrite(byte[] byArray, String string, String string2) {
        boolean bl = false;
        try {
            new File(string).getParentFile().mkdirs();
            OSUtil.chmod(new File(string).getParentFile(), "777");
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            OSUtil.chmod(string, string2);
        }
        catch (Exception exception) {
            bl = true;
            OpsOut.println("Error during file copy");
            DevOut.trace(exception);
        }
        return bl;
    }

    protected static Map initializeMimeTypeMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>(50);
        hashMap.put("aif", "audio/x-aiff");
        hashMap.put("aifc", "audio/x-aiff");
        hashMap.put("aiff", "audio/x-aiff");
        hashMap.put("au", "audio/basic");
        hashMap.put("mid", "audio/midi");
        hashMap.put("midi", "audio/midi");
        hashMap.put("mp2", "audio/mpeg");
        hashMap.put("mp3", "audio/mpeg");
        hashMap.put("mpga", "audio/mpeg");
        hashMap.put("ra", "audio/x-realaudio");
        hashMap.put("rpm", "audio/x-pn-realaudio-plugin");
        hashMap.put("snd", "audio/basic");
        hashMap.put("wav", "audio/x-wav");
        hashMap.put("doc", "application/msword");
        hashMap.put("pdf", "application/pdf");
        hashMap.put("ppt", "application/vnd.ms-powerpoint");
        hashMap.put("swf", "application/x-shockwave-flash");
        hashMap.put("xls", "application/vnd.ms-excel");
        hashMap.put("bmp", "image/bmp");
        hashMap.put("gif", "image/gif");
        hashMap.put("jpe", "image/jpeg");
        hashMap.put("jpeg", "image/jpeg");
        hashMap.put("jpg", "image/jpeg");
        hashMap.put("png", "image/png");
        hashMap.put("tif", "image/tiff");
        hashMap.put("tiff", "image/tiff");
        hashMap.put("avi", "video/x-msvideo");
        hashMap.put("mov", "video/quicktime");
        hashMap.put("mpe", "video/mpeg");
        hashMap.put("mpeg", "video/mpeg");
        hashMap.put("mpg", "video/mpeg");
        hashMap.put("qt", "video/quicktime");
        hashMap.put("ram", "audio/x-pn-realaudio");
        hashMap.put("rm", "audio/x-pn-realaudio");
        hashMap.put("wmv", "video/x-ms-wmv");
        return hashMap;
    }
}

