/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.IOException;
import java.io.PushbackInputStream;
import panther.util.general.DataAccessor;

public class CountingFileStream {
    protected int characterCount = 0;
    protected PushbackInputStream in;

    public CountingFileStream(DataAccessor dataAccessor) throws IOException {
        this.in = new PushbackInputStream(dataAccessor.getInputStream());
    }

    public int getCharacterCount() {
        return this.characterCount;
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = true;
        do {
            n = this.read();
            if (bl && n == -1) {
                return null;
            }
            bl = false;
            if (n == -1 || this.endsLine(n)) continue;
            stringBuffer.append((char)n);
        } while (n != -1 && !this.endsLine(n));
        if (this.endsLine(n)) {
            this.unread(n);
            this.readLineEnd();
        }
        return stringBuffer.toString();
    }

    protected void readLineEnd() throws IOException {
        this.readCrs();
        this.readLfs();
    }

    protected void readCrs() throws IOException {
        if (this.isCr(this.peek())) {
            this.read();
        }
        while (this.isCr(this.peek())) {
            this.readFree();
        }
    }

    protected void readLfs() throws IOException {
        if (this.isLf(this.peek())) {
            this.read();
        }
        while (this.isLf(this.peek())) {
            this.readFree();
        }
    }

    protected int peek() throws IOException {
        int n = this.read();
        this.unread(n);
        return n;
    }

    protected int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            ++this.characterCount;
        }
        return n;
    }

    protected int readFree() throws IOException {
        int n = this.in.read();
        return n;
    }

    protected void unread(int n) throws IOException {
        if (n != -1) {
            this.in.unread(n);
            --this.characterCount;
        }
    }

    protected void unreadAll(String string) throws IOException {
        for (int i = string.length() - 1; i >= 0; --i) {
            this.unread(string.charAt(i));
        }
    }

    protected boolean endsLine(int n) {
        return this.isCr(n) || this.isLf(n);
    }

    protected boolean isCr(int n) {
        return n == 13;
    }

    protected boolean isLf(int n) {
        return n == 10;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }
}

