/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayUtils {
    public static byte[] combine(byte[] ... byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(ByteArrayUtils.length(byArray));
        for (byte[] byArray2 : byArray) {
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean contains(byte[] byArray, byte[] byArray2) {
        return ByteArrayUtils.indexOf(byArray, byArray2) >= 0;
    }

    public static boolean contains(byte[] byArray, byte[] byArray2, int n) {
        return ByteArrayUtils.indexOf(byArray, byArray2, n) >= 0;
    }

    public static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        byteArrayOutputStream.write(byArray, n, n2);
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean endsWith(byte[] byArray, byte[] byArray2) {
        if (byArray2.length > byArray.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[byArray.length - byArray2.length + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) {
        return ByteArrayUtils.indexOf(byArray, byArray2, 0);
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray.length - byArray2.length;
        for (int i = n; i <= n2; ++i) {
            if (!ByteArrayUtils.startsWith(byArray, byArray2, i)) continue;
            return i;
        }
        return -1;
    }

    public static int length(byte[] ... byArray) {
        int n = 0;
        for (byte[] byArray2 : byArray) {
            n += byArray2.length;
        }
        return n;
    }

    public static void print(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            System.out.println(i + " = " + byArray[i] + " (" + (char)byArray[i] + ")");
        }
    }

    public static void print(String string, String string2) throws Exception {
        ByteArrayUtils.print(string.getBytes(string2));
    }

    public static byte[] removeEnd(byte[] byArray, byte[] byArray2) {
        if (ByteArrayUtils.endsWith(byArray, byArray2)) {
            return ByteArrayUtils.copyOfRange(byArray, 0, byArray.length - byArray2.length);
        }
        return byArray;
    }

    public static byte[] removeStart(byte[] byArray, byte[] byArray2) {
        if (ByteArrayUtils.startsWith(byArray, byArray2)) {
            return ByteArrayUtils.copyOfRange(byArray, byArray2.length, byArray.length - byArray2.length);
        }
        return byArray;
    }

    public static List<ByteArrayInputStream> split(byte[] byArray, byte[] byArray2) {
        ArrayList<ByteArrayInputStream> arrayList = new ArrayList<ByteArrayInputStream>();
        int n = 0;
        int n2 = ByteArrayUtils.indexOf(byArray, byArray2);
        while (n2 >= 0) {
            arrayList.add(new ByteArrayInputStream(byArray, n, n2 - n));
            n = n2 + byArray2.length;
            n2 = ByteArrayUtils.indexOf(byArray, byArray2, n);
        }
        arrayList.add(new ByteArrayInputStream(byArray, n, byArray.length - n));
        return arrayList;
    }

    public static boolean startsWith(byte[] byArray, byte[] byArray2) {
        return ByteArrayUtils.startsWith(byArray, byArray2, 0);
    }

    public static boolean startsWith(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2.length + n > byArray.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] subarray(byte[] byArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 - n);
        byteArrayOutputStream.write(byArray, n, n2 - n);
        return byteArrayOutputStream.toByteArray();
    }
}

