/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.FileDescriptor;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import panther.util.general.BooleanMeta;
import panther.util.general.IntMeta;
import panther.util.general.LongMeta;
import panther.util.general.StringMeta;

public class Argumatic {
    private Map objArgs = new TreeMap();
    private Object targetObject = null;
    private int argCount = 0;
    private int errorCount = 0;
    private static final PrintWriter STDOUT = new PrintWriter(new FileWriter(FileDescriptor.out));
    private static final Logger logger = Logger.getLogger(Argumatic.class.getName());
    private static final Class[] NO_ARG_TYPES = new Class[0];
    private static final Object[] NO_ARG_PARAMS = new Object[0];
    private static final String ARG_SETTER_METHOD_PREFIX = "set";
    private static final String ARG_GETTER_METHOD_PREFIX = "get";
    private static final String ARG_ALT_BOOL_GETTER_METHOD_PREFIX = "is";
    private static final String ARG_META_PREFIX = "get";
    private static final String ARG_META_SUFFIX = "Meta";

    public Argumatic(String[] stringArray, Object object) {
        this.targetObject = object;
        if (object != null) {
            this.processMethods();
            this.processArgs(stringArray);
        }
    }

    private void processArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            String string2 = stringArray[i];
            for (n = 0; n < string2.length() && string2.charAt(n) == '-'; ++n) {
            }
            String string3 = null;
            int n2 = string2.indexOf(61);
            if (n2 < 0) {
                string = string2.substring(n);
            } else {
                string = string2.substring(n, n2);
                string3 = string2.substring(n2 + 1);
            }
            if (this.setArgument(string, string3)) {
                ++this.argCount;
                continue;
            }
            ++this.errorCount;
        }
    }

    public int getArgCount() {
        return this.argCount;
    }

    public boolean hasError() {
        return this.errorCount > 0;
    }

    public void displayUsage() {
        this.displayUsage(STDOUT);
        STDOUT.flush();
    }

    public void displayUsage(PrintWriter printWriter) {
        printWriter.println("Usage:");
        for (Arg arg : this.objArgs.values()) {
            String string;
            printWriter.print("--");
            printWriter.print(arg.getName());
            printWriter.print("=");
            printWriter.print(arg.getMeta().getTypeStr());
            Object object = arg.getDefaultValue();
            if (object != null && (string = object.toString()) != null) {
                printWriter.print(" [");
                printWriter.print(string);
                printWriter.print("]");
            }
            if ((string = arg.getMeta().getHelp()) != null) {
                printWriter.print("       ");
                printWriter.print(string);
            }
            printWriter.println();
        }
    }

    public void displaySummary() {
        this.displaySummary(STDOUT);
        STDOUT.flush();
    }

    public void displaySummary(PrintWriter printWriter) {
        printWriter.println("Summary:");
        for (Arg arg : this.objArgs.values()) {
            String string;
            printWriter.print(arg.getName());
            printWriter.print("=");
            String string2 = "NULL";
            Object object = arg.getValue();
            if (object != null && (string = object.toString()) != null) {
                string2 = string;
            }
            printWriter.print(string2);
            printWriter.println();
        }
    }

    private void processMethods() {
        Class<?> clazz = this.targetObject.getClass();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string = method.getName();
            if (!string.startsWith(ARG_SETTER_METHOD_PREFIX) || string.length() <= ARG_SETTER_METHOD_PREFIX.length()) continue;
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz2 = method.getReturnType();
            if (classArray.length != 1 || !classArray[0].isPrimitive() && classArray[0] != String.class || clazz2 != Void.TYPE) continue;
            Meta meta = Argumatic.getMeta(methodArray, this.targetObject, string = string.substring(ARG_SETTER_METHOD_PREFIX.length()));
            if (meta == null) {
                meta = Argumatic.getDefaultMeta(classArray[0]);
            }
            Method method2 = Argumatic.getGetterMethod(methodArray, string, classArray[0]);
            string = Argumatic.getArgName(string);
            Arg arg = new Arg(string, method, meta, method2);
            this.objArgs.put(string, arg);
        }
    }

    private static Meta getDefaultMeta(Class clazz) {
        Meta meta = Meta.DEFAULT_STRING_META;
        if (clazz == Integer.TYPE) {
            meta = Meta.DEFAULT_INT_META;
        } else if (clazz == Boolean.TYPE) {
            meta = Meta.DEFAULT_BOOLEAN_META;
        } else if (clazz == Long.TYPE) {
            meta = Meta.DEFAULT_LONG_META;
        }
        return meta;
    }

    private static Method getGetterMethod(Method[] methodArray, String string, Class clazz) {
        Method method = null;
        String string2 = "get" + string;
        String string3 = null;
        if (clazz == Boolean.TYPE) {
            string3 = ARG_ALT_BOOL_GETTER_METHOD_PREFIX + string;
        }
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            if (method2.getParameterTypes().length != 0 || method2.getReturnType() != clazz) continue;
            boolean bl = method2.getName().equals(string2);
            if (!bl && clazz == Boolean.TYPE) {
                bl = method2.getName().equals(string3);
            }
            if (!bl) continue;
            method = method2;
        }
        return method;
    }

    private static Meta getMeta(Method[] methodArray, Object object, String string) {
        Meta meta = null;
        Method method = null;
        String string2 = "get" + string + ARG_META_SUFFIX;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            if (!method2.getName().equals(string2) || method2.getParameterTypes().length != 0 || !Meta.class.isAssignableFrom(method2.getReturnType())) continue;
            method = method2;
            break;
        }
        if (method != null) {
            Object object2 = Argumatic.invokeMethod(object, method, NO_ARG_PARAMS);
            if (object2 != null) {
                if (object2 instanceof Meta) {
                    meta = (Meta)object2;
                } else {
                    logger.warning("Method " + string2 + " from " + object.getClass().getName() + " returned non meta-derived class.");
                }
            } else {
                logger.finest("Method " + string2 + " from " + object.getClass().getName() + " returned NULL");
            }
        }
        return meta;
    }

    private boolean setArgument(String string, String string2) {
        boolean bl = false;
        Arg arg = (Arg)this.objArgs.get(string);
        if (arg != null) {
            bl = arg.setValue(string2);
        } else {
            logger.warning("No receiver method for argument: " + string);
        }
        return bl;
    }

    private static String getArgName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                if (bl) {
                    stringBuffer.append('-');
                }
                c = Character.toLowerCase(c);
                bl = false;
            } else {
                bl = true;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static Object invokeMethod(Object object, Method method, Object[] objectArray) {
        Object object2 = null;
        try {
            object2 = method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.WARNING, "IllegalAccessException " + method.getName() + " on a " + object.getClass().getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.WARNING, "IllegalArgumentException " + method.getName() + " on a " + object.getClass().getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.log(Level.WARNING, "InvocationTargetException " + method.getName() + " on a " + object.getClass().getName());
        }
        return object2;
    }

    private class Arg {
        private String name;
        private Meta meta;
        private Method setterMethod;
        private Method getterMethod;
        private Object defaultValue = null;

        public Arg(String string, Method method, Meta meta, Method method2) {
            this.name = string;
            this.setterMethod = method;
            this.meta = meta;
            this.getterMethod = method2;
            this.defaultValue = this.getValue();
        }

        public boolean setValue(String string) {
            Object object = null;
            try {
                object = this.meta.convert(string);
            }
            catch (Throwable throwable) {
                logger.warning("argument '" + this.name + "': " + throwable.getMessage());
                return false;
            }
            try {
                this.setterMethod.invoke(Argumatic.this.targetObject, object);
                return true;
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.log(Level.WARNING, "IllegalAccessException " + this.setterMethod.getName() + " on a " + Argumatic.this.targetObject.getClass().getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.log(Level.WARNING, "IllegalArgumentException " + this.setterMethod.getName() + " on a " + Argumatic.this.targetObject.getClass().getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.log(Level.WARNING, "InvocationTargetException " + this.setterMethod.getName() + " on a " + Argumatic.this.targetObject.getClass().getName());
            }
            return false;
        }

        public Object getValue() {
            Object object = null;
            if (this.getterMethod != null) {
                object = Argumatic.invokeMethod(Argumatic.this.targetObject, this.getterMethod, NO_ARG_PARAMS);
            }
            return object;
        }

        public String getName() {
            return this.name;
        }

        public Meta getMeta() {
            return this.meta;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static abstract class Meta {
        public static Meta DEFAULT_INT_META = new IntMeta(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
        public static Meta DEFAULT_STRING_META = new StringMeta(null);
        public static Meta DEFAULT_BOOLEAN_META = new BooleanMeta(null);
        public static Meta DEFAULT_LONG_META = new LongMeta(null, Long.MIN_VALUE, Long.MAX_VALUE);
        private String help = null;

        public static Meta getStringMeta(String string) {
            return new StringMeta(string);
        }

        public static Meta getIntMeta(String string, int n, int n2) {
            return new IntMeta(string, n, n2);
        }

        public static Meta getBooleanMeta(String string) {
            return new BooleanMeta(string);
        }

        public static Meta getLongMeta(String string, long l, long l2) {
            return new LongMeta(string, l, l2);
        }

        public Meta(String string) {
            this.help = string;
        }

        public String getHelp() {
            return this.help;
        }

        public abstract Object convert(String var1);

        public abstract String getTypeStr();
    }
}

