/*
 * Decompiled with CFR 0.152.
 */
package panther.util.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import panther.util.general.BigDecimalIterator;
import panther.util.general.CollectionUtils;
import panther.util.unicon.DBUtil;

public class SequenceGenerator {
    private static final Logger logger = Logger.getLogger(SequenceGenerator.class.getName());
    protected Connection connection;
    protected String dbProductName;
    protected String tableName;

    public SequenceGenerator(Connection connection, String string, String string2) {
        this.connection = connection;
        this.dbProductName = string;
        this.tableName = string2;
    }

    public BigDecimal nextValue(String string) throws SQLException {
        BigDecimalIterator bigDecimalIterator = this.allocate(string, 1);
        if (bigDecimalIterator.hasNext()) {
            return bigDecimalIterator.next();
        }
        return null;
    }

    public BigDecimalIterator nextValues(String string, int n) throws SQLException {
        return this.allocate(string, n);
    }

    protected BigDecimalIterator allocate(String string, int n) throws SQLException {
        int n2;
        List list;
        if (n <= 0) {
            return new BigDecimalIterator(1L, 0L);
        }
        Number number = null;
        String string2 = null;
        DBUtil.begin(this.connection, this.dbProductName);
        String string3 = "select next_value from " + this.tableName + " where name = ? " + DBUtil.forUpdateString(this.dbProductName);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("sequence-gen: db-product=" + this.dbProductName + ",select sql: " + string3);
        }
        if ((list = DBUtil.queryUnique(this.connection, string3, string)) == null || list.isEmpty()) {
            logger.severe("Got a null value for sequence " + string);
            DBUtil.safeRollback(this.connection);
            throw new Error("Got null value for sequence " + string);
        }
        number = (Number)list.get(0);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("sequence-gen: allocated: " + number);
        }
        string2 = "update " + this.tableName + " set next_value = ? where name = ?";
        BigDecimal bigDecimal = BigDecimal.valueOf(number.longValue());
        BigDecimal bigDecimal2 = BigDecimal.valueOf(bigDecimal.longValue() + (long)n - 1L);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(bigDecimal.longValue() + (long)n);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("sequence-gen: update sql: " + string2 + ",nextValue=" + bigDecimal3);
        }
        if ((n2 = DBUtil.executeUpdate(this.connection, string2, CollectionUtils.arrayList(bigDecimal3, string))) <= 0) {
            DBUtil.safeRollback(this.connection);
            throw new Error("Unable to update SEQUENCE " + string + " in SequenceGenerator");
        }
        DBUtil.commit(this.connection, this.dbProductName);
        return new BigDecimalIterator(bigDecimal, bigDecimal2);
    }
}

