/*
 * Decompiled with CFR 0.152.
 */
package panther.util.db;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import panther.util.general.ErrorUtils;

public class DBUtils {
    public static void dumpResultSet(ResultSet resultSet, PrintStream printStream) throws Exception {
        DBUtils.dumpResultSet(resultSet, new PrintWriter(printStream));
    }

    public static void dumpResultSet(ResultSet resultSet, PrintWriter printWriter) throws Exception {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        for (n = 1; n <= n2; ++n) {
            printWriter.print(resultSetMetaData.getColumnName(n));
            printWriter.print("\t");
        }
        printWriter.println();
        n = 0;
        while (resultSet.next()) {
            ++n;
            for (int i = 1; i <= n2; ++i) {
                Object object = resultSet.getObject(i);
                printWriter.print(resultSet.getObject(i));
                printWriter.print("\t");
            }
            printWriter.println();
        }
        printWriter.println("\n\t" + n + " rows");
        printWriter.flush();
    }

    public static void dumpResultSetLong(String string, ResultSet resultSet, PrintStream printStream) throws Exception {
        DBUtils.dumpResultSetLong(string, resultSet, new PrintWriter(printStream));
    }

    public static void dumpResultSetLong(String string, ResultSet resultSet, PrintWriter printWriter) throws Exception {
        printWriter.println("\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
        printWriter.println(string);
        printWriter.println();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        printWriter.println(n + " column(s)");
        int n2 = 0;
        while (resultSet.next()) {
            ++n2;
            for (int i = 1; i <= n; ++i) {
                printWriter.println(resultSetMetaData.getColumnName(i) + " = " + resultSet.getObject(i));
            }
            printWriter.println();
        }
        printWriter.println(n2 + " row(s)");
        printWriter.println("------------------------------------------------------------\n");
    }

    public static void dumpStatement(Statement statement, PrintStream printStream) {
        DBUtils.dumpStatement(statement, new PrintWriter(printStream));
    }

    public static void dumpStatement(Statement statement, PrintWriter printWriter) {
        printWriter.println("What's up?");
        boolean bl = false;
        int n = 1;
        while (!bl) {
            boolean bl2 = false;
            ResultSet resultSet = null;
            int n2 = -1;
            printWriter.println("Hello!");
            try {
                bl2 = statement.getMoreResults();
                printWriter.println("moreResults = " + bl2);
            }
            catch (Throwable throwable) {
                ErrorUtils.checkSwallow(throwable);
            }
            printWriter.println("Now I'm here!");
            bl = true;
            try {
                if (bl2 && (resultSet = statement.getResultSet()) != null) {
                    printWriter.println("Result Set #" + n);
                    DBUtils.dumpResultSet(resultSet, printWriter);
                    bl = false;
                }
            }
            catch (Throwable throwable) {
                ErrorUtils.checkSwallow(throwable);
            }
            try {
                if (resultSet == null && (n2 = statement.getUpdateCount()) >= 0) {
                    printWriter.println("update count #" + n + " = " + n2);
                    bl = false;
                }
            }
            catch (Throwable throwable) {
                ErrorUtils.checkSwallow(throwable);
            }
            ++n;
        }
        printWriter.flush();
    }
}

