/*
 * Decompiled with CFR 0.152.
 */
package panther.util.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import panther.util.general.DevOut;

public class BLOBObject {
    protected Blob blob;
    protected byte[] rawBytes;
    protected Object object;
    protected boolean objectConstructed = false;

    public BLOBObject() {
    }

    public BLOBObject(Blob blob) {
        this.blob = blob;
        this.initializeBytes();
    }

    public byte[] getBytes() {
        return this.rawBytes;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass();
    }

    public Object getObject() {
        if (!this.objectConstructed) {
            this.constructObject();
        }
        return this.object;
    }

    public void setObject(Serializable serializable) {
        this.objectConstructed = true;
        this.object = serializable;
        this.rawBytes = this.getBytes(serializable);
    }

    protected void constructObject() {
        this.object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.rawBytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.object = objectInputStream.readObject();
            objectInputStream.close();
            ((InputStream)byteArrayInputStream).close();
        }
        catch (Exception exception) {
            DevOut.trace(exception);
        }
        this.objectConstructed = true;
    }

    protected void initializeBytes() {
        this.object = null;
        this.rawBytes = null;
        this.objectConstructed = false;
        try {
            this.rawBytes = this.blob.getBytes(1L, (int)this.blob.length());
        }
        catch (SQLException sQLException) {
            DevOut.trace(sQLException);
            throw new Error("Error getting BLOB bytes from database");
        }
    }

    protected byte[] getBytes(Serializable serializable) {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            byArray = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            DevOut.trace(exception);
        }
        return byArray;
    }
}

