/*
 * Decompiled with CFR 0.152.
 */
package panther.program;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import panther.client.LogManager;
import panther.program.AbstractScore;
import panther.program.MarvelPreprocessor;
import panther.program.PSEMarvelScore;
import pse.assessment.PantherForm;
import pse.assessment.PantherTask;
import pse.configuration.PageCollection;
import pse.core.PantherEngine;
import pse.result.Result;
import pse.result.Session;
import pse.util.general.XmlUtils;

public class MarvelIipRequestProcessor
extends AbstractScore {
    protected Socket socket;
    protected LogManager logManager;

    public MarvelIipRequestProcessor(Socket socket, LogManager logManager) {
        this.socket = socket;
        this.logManager = logManager;
    }

    public void process() throws Exception {
        String string;
        PantherEngine pantherEngine = new PantherEngine();
        this.send("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<version pse=\"" + pantherEngine.getVersion() + "\" front-end=\"0.0.1\" />\n");
        this.logManager.log("PSE version XML sent");
        String string2 = this.receive();
        if (string2.trim().length() > 0 && (string = this.getIipHtml(string2)).trim().length() > 0) {
            this.send("<pse-grade-response><![CDATA[" + string + " ]]></pse-grade-response>");
        }
    }

    protected String getIipHtml(String string) throws Exception {
        Document document = XmlUtils.parseToDocument(string);
        Node node = XmlUtils.getChildNamed(document, "pse-grade-request");
        Node node2 = XmlUtils.getChildNamed(node, "panther-task");
        PantherTask pantherTask = new PantherTask();
        pantherTask.fromMyNode(node2);
        PantherForm pantherForm = this.createDefaultForm(pantherTask);
        Session session = this.createDefaultSession(pantherForm, pantherTask, null);
        MarvelPreprocessor marvelPreprocessor = new MarvelPreprocessor();
        Result result = marvelPreprocessor.extractResult(session, node2);
        PSEMarvelScore pSEMarvelScore = new PSEMarvelScore();
        HashMap<String, Object> hashMap = pSEMarvelScore.getObservableMap(node);
        pSEMarvelScore.setMarvelCompoundObservableEarnedPoints(result, hashMap);
        pSEMarvelScore.setMarvelPrimaryObservable(result, hashMap);
        PantherEngine pantherEngine = this.instantiateEngine();
        Result result2 = pantherEngine.score(result, pantherTask, pantherForm);
        this.logManager.log("PSE scoring done");
        pSEMarvelScore.setMarvelReportingObservable(result2, node2, hashMap);
        PageCollection pageCollection = new PageCollection();
        InputStreamReader inputStreamReader = new InputStreamReader(this.getClass().getResourceAsStream("/iip-content.xml"));
        pageCollection.read("/iip-content.xml", inputStreamReader);
        inputStreamReader.close();
        String string2 = pantherEngine.generateIip(result2, pantherTask, pantherForm, pageCollection);
        this.logManager.log("PSE IIP generated");
        return string2;
    }

    protected String receive() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = this.socket.getInputStream();
        boolean bl = false;
        while (!bl) {
            int n = inputStream.read();
            if (n == 0 || n == -1) {
                bl = true;
                continue;
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    protected void send(String string) throws Exception {
        PrintStream printStream = new PrintStream(this.socket.getOutputStream(), true);
        printStream.print(string);
        printStream.write(0);
        printStream.flush();
    }
}

