/*
 * Decompiled with CFR 0.152.
 */
package panther.pep;

import apicore.ptmp.PTSessionClosedError;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import panther.pep.InterruptProgressImpl;
import panther.pep.LaunchProgressImpl;
import panther.pep.SubmitProgressImpl;
import panther.util.general.Constants;
import panther.util.general.NoTricksTimerThread;
import panther.util.general.ProportionalBox;
import panther.util.general.ProportionalLayoutManager;
import panther.util.general.RandomUtils;
import panther.util.general.WatcherThread;
import panther.util.smalltalk.SimpleBlock;
import panther.util.unicon.GuaranteedActionStrict;
import panther.xp.PantherAssessmentState;
import panther.xp.XPass;
import panther.xp.XPassUnavailableException;
import pse.core.PantherEngine;
import pse.pt.PacketTracer;
import pse.pt.PacketTracerUtils;
import pse.result.IosLog;
import pse.result.Result;
import pse.result.Session;
import pse.result.SessionEnd;
import pse.result.SittingEnd;
import pse.result.SittingStart;
import pse.util.general.ApplicationError;
import pse.util.general.InterruptProgress;
import pse.util.general.LaunchProgress;
import pse.util.general.SubmitProgress;
import pse.util.general.ThreadUtils;
import skeletonapplet.AbstractDelegatorApplet;
import skeletonapplet.AppletWorker;
import skeletonapplet.JreInfo;
import skeletonapplet.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamWorker
implements AppletWorker {
    protected AbstractDelegatorApplet applet;
    protected XPass xpass;
    protected PacketTracer packetTracer;
    protected JButton interruptButton;
    protected JButton submitButton;
    protected JLabel timeLabel;
    protected JProgressBar progressBar;
    protected NoTricksTimerThread secondTimer;
    protected NoTricksTimerThread autoSaveTimer;
    protected WatcherThread packetTracerWatcher;
    protected boolean timersOn = false;
    protected boolean warnAboutTimeRemaining = true;
    protected JDialog timeWarningDialog;
    protected boolean submittedSuccessfully = false;
    protected boolean finalSaveDone = false;
    protected Result pantherResult;
    protected IosLog startingLog;
    protected LaunchProgress launchProgress;
    protected InterruptProgress interruptProgress;
    protected SubmitProgress submitProgress;
    protected boolean packetTracerClosed = false;
    protected boolean launchCompleted = false;
    protected long timeRemainingAtStart = -1L;
    protected long timeElapsedDuringThisSession = 0L;
    protected boolean isContinued;
    protected String minimumPtVersionSpecific;
    protected boolean submitNeedsPt = false;
    protected int maximumPkaLoadTimeInSeconds = 120;
    protected int autoSaveIntervalInMilliseconds = 300000;
    protected JEditorPane overlayMessagePane;
    protected boolean exceptionsOff = false;
    protected String myId;

    public ExamWorker() {
        JreInfo.soleInstance().ptaBuild().setValueOkay("12.009");
    }

    @Override
    public void setApplet(AbstractDelegatorApplet abstractDelegatorApplet) {
        this.applet = abstractDelegatorApplet;
        this.overlayMessagePane = new JEditorPane();
        this.overlayMessagePane.setContentType("text/html");
        Color color = new Color(215, 215, 215, 100);
        this.overlayMessagePane.setBackground(color);
        JScrollPane jScrollPane = new JScrollPane(this.overlayMessagePane);
        jScrollPane.setBackground(color);
        abstractDelegatorApplet.setGlassPane(jScrollPane);
        abstractDelegatorApplet.getGlassPane().setVisible(false);
    }

    @Override
    public String getBuildVersion() {
        return "12.009";
    }

    @Override
    public Date getLoadDate() {
        return Constants.LOAD_DATE;
    }

    @Override
    public void instanceCreation() {
        this.exceptionsOff = false;
        Utilities.logPrintln("\n\n" + this + " INSTANCECREATION start \n\n");
        this.submitButton = new JButton("Submit Assessment");
        this.submitButton.addActionListener(this);
        this.submitButton.setBorder(BorderFactory.createBevelBorder(0));
        this.submitButton.setEnabled(false);
        this.interruptButton = new JButton("Save Assessment and Continue Later");
        this.interruptButton.addActionListener(this);
        this.interruptButton.setBorder(BorderFactory.createBevelBorder(0));
        this.interruptButton.setEnabled(false);
        this.timeLabel = new JLabel("Time Remaining: ...");
        this.timeLabel.setHorizontalAlignment(0);
        this.progressBar = new JProgressBar(0);
        this.applet.setLayout(new ProportionalLayoutManager());
        this.applet.add((Component)this.timeLabel, new ProportionalBox(25, 2, 50, 22));
        this.applet.add((Component)this.submitButton, new ProportionalBox(25, 27, 50, 22));
        this.applet.add((Component)this.interruptButton, new ProportionalBox(25, 52, 50, 22));
        this.applet.add((Component)this.progressBar, new ProportionalBox(5, 76, 90, 22));
        this.applet.setVisible(false);
        Utilities.logPrintln("\n\n" + this + " INSTANCECREATION end \n\n");
    }

    @Override
    public void init() {
        this.myId = String.valueOf(this.hashCode()) + RandomUtils.chooseInt(1001, 9999);
        Utilities.logPrintln("\n\n" + this + " INIT " + this.myId + " start \n\n");
        this.exceptionsOff = false;
        try {
            Object object;
            String string;
            Object object2;
            String string2 = this.getParameter("backgroundcolor");
            if (string2 != null && string2.length() > 0) {
                try {
                    object2 = new Color(Integer.parseInt(string2, 16));
                    this.applet.setBackground((Color)object2);
                    this.applet.getContentPane().setBackground((Color)object2);
                    this.submitButton.setBackground(Color.LIGHT_GRAY);
                    this.interruptButton.setBackground(Color.LIGHT_GRAY);
                    this.timeLabel.setBackground(this.applet.getBackground());
                    this.progressBar.setBackground(this.applet.getBackground());
                }
                catch (Throwable throwable) {
                    pse.util.general.Utilities.checkIgnore(throwable);
                }
            }
            if ((object2 = this.getParameter("maxpkaloadtime")) != null && ((String)object2).trim().length() > 0) {
                try {
                    this.maximumPkaLoadTimeInSeconds = Integer.parseInt((String)object2);
                }
                catch (Throwable throwable) {
                    pse.util.general.Utilities.checkIgnore(throwable);
                }
            }
            if ((string = this.getParameter("autosaveintervalinmilliseconds")) != null && string.trim().length() > 0) {
                try {
                    this.autoSaveIntervalInMilliseconds = Integer.parseInt(string);
                }
                catch (Throwable throwable) {
                    pse.util.general.Utilities.checkIgnore(throwable);
                }
            }
            try {
                object = this.getParameter("iscontinued", "false");
                this.isContinued = Boolean.parseBoolean((String)object);
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.check(throwable);
                this.isContinued = false;
            }
            this.minimumPtVersionSpecific = this.getParameter("minimumptversionspecific", Constants.MINIMUM_PT_VERSION_SPECIFIC_PARAMETER_DEFAULT);
            this.xpass = new XPass(this.myId);
            this.xpass.initialize(this.applet, this.getParameter("message"));
            this.xpass.register();
            this.applet.setVisible(true);
            this.submitButton.setVisible(true);
            this.interruptButton.setVisible(true);
            this.timeLabel.setVisible(true);
            this.progressBar.setVisible(true);
            object = new Thread(){

                public void run() {
                    ExamWorker.this.launchPacketTracer();
                }
            };
            ((Thread)object).start();
            this.createTimers();
            this.packetTracerWatcher = this.createPacketTracerWatcher();
            this.packetTracerWatcher.start();
        }
        catch (Throwable throwable) {
            this.handleTopLevelThrowable(throwable);
        }
        Utilities.logPrintln("\n\n" + this + " INIT " + this.myId + " end \n\n");
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void performComplete() {
    }

    @Override
    public void performInterrupt() {
    }

    @Override
    public void performQuit() {
    }

    @Override
    public void start() {
        this.exceptionsOff = false;
        Utilities.logPrintln("\n\n" + this + " START " + this.myId + " start \n\n");
        try {
            this.submitButton.paintImmediately(this.submitButton.getVisibleRect());
        }
        catch (Throwable throwable) {
            pse.util.general.Utilities.checkSwallow(throwable);
        }
        try {
            this.interruptButton.paintImmediately(this.interruptButton.getVisibleRect());
        }
        catch (Throwable throwable) {
            pse.util.general.Utilities.checkSwallow(throwable);
        }
        try {
            this.timeLabel.paintImmediately(this.timeLabel.getVisibleRect());
        }
        catch (Throwable throwable) {
            pse.util.general.Utilities.checkSwallow(throwable);
        }
        try {
            this.progressBar.paintImmediately(this.progressBar.getVisibleRect());
        }
        catch (Throwable throwable) {
            pse.util.general.Utilities.checkSwallow(throwable);
        }
        try {
            if (this.launchCompleted) {
                this.checkAssessmentState();
            }
        }
        catch (Throwable throwable) {
            this.handleTopLevelThrowable(throwable);
        }
        Utilities.logPrintln("\n\n" + this + " START " + this.myId + " end \n\n");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.submitButton) {
                this.submit(false);
            } else if (actionEvent.getSource() == this.interruptButton) {
                this.interrupt();
            } else {
                Utilities.logPrintln("ExamApplet received event " + actionEvent + " from unknown source " + actionEvent.getSource());
            }
        }
        catch (Throwable throwable) {
            this.handleTopLevelThrowable(throwable);
        }
    }

    @Override
    public void stop() {
        this.exceptionsOff = true;
        Utilities.logPrintln("\n\n" + this + " STOP " + this.myId + " start \n\n");
        this.disableWidgets();
        Utilities.logPrintln("\n\n" + this + " STOP " + this.myId + " end \n\n");
    }

    @Override
    public void destroy() {
        Utilities.logPrintln("\n\n" + this + " DESTROY " + this.myId + " start \n\n");
        this.exceptionsOff = true;
        try {
            this.exiting();
            this.closePacketTracer();
        }
        catch (Throwable throwable) {
            pse.util.general.Utilities.check(throwable);
        }
        Utilities.logPrintln("\n\n" + this + " DESTROY " + this.myId + " end \n\n");
    }

    protected void addOptionalDelay(String string) {
        if (Utilities.isFeatureDefined("testdelay")) {
            this.progressBar.setString(string);
            ThreadUtils.guaranteedSleep(5000L);
        }
    }

    protected void addPreSubmitDelay() {
        if (Utilities.isFeatureDefined("presubmitdelay")) {
            ThreadUtils.guaranteedSleep(2000L);
        }
        if (Utilities.isFeatureDefined("presubmitstatecheck")) {
            try {
                this.xpass.getAssessmentState();
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.check(throwable);
            }
        }
    }

    protected void allowCloseWindow() {
        this.warn("Unable To Close Window", "We are unable to close your browser window at this time.\nYou will have to use Task Manager to close it,\nor it will be closed when you shut down your computer.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void autoSave() throws Throwable {
        if (!this.packetTracer.isPka()) {
            return;
        }
        this.checkAssessmentState();
        Session session = this.pantherResult.getSession();
        Calendar calendar = Calendar.getInstance();
        long l = session.getTimeAllowed();
        long l2 = this.getCurrentTimeRemaining();
        long l3 = l - l2;
        SittingEnd sittingEnd = new SittingEnd();
        sittingEnd.setClientTime(calendar);
        sittingEnd.setServerTimeForFillIn();
        sittingEnd.setTimeRemaining(l2);
        sittingEnd.setTimeUsed(l3);
        IosLog iosLog = this.packetTracer.getIosLog(this.startingLog);
        byte[] byArray = this.packetTracer.extractBytes();
        String string = null;
        Result result = this.pantherResult;
        synchronized (result) {
            this.pantherResult.noteAutoSave(byArray, iosLog, Calendar.getInstance());
            session.addEvent(sittingEnd);
            string = this.pantherResult.toXmlStringWithDocType();
            this.pantherResult.getWorkProduct().setIosLog(this.startingLog);
            session.removeEvent(sittingEnd);
        }
        try {
            this.xpass.putAutoSaveXml(string);
        }
        catch (Throwable throwable) {
            this.reThrowXPassThrowable(throwable);
        }
    }

    protected void autoSaveElapsed(long l) {
        block10: {
            if (this.timersOn) {
                if (this.xpass.isInAutoSave()) {
                    Utilities.logPrintln("Older autosave in progress; current autosave is ignored");
                } else if (this.xpass.isInFinalSave()) {
                    Utilities.logPrintln("Final save has begun; current autosave is ignored");
                } else {
                    try {
                        if (this.xpassAvailable()) {
                            this.autoSave();
                        }
                    }
                    catch (ApplicationError.SaveGeneration saveGeneration) {
                        if (this.timersOn) {
                            Utilities.logPrintln("Autosave process ended by a later generation autosave");
                        }
                    }
                    catch (Throwable throwable) {
                        if (!this.timersOn) break block10;
                        this.handleTopLevelThrowable(throwable);
                    }
                }
            }
        }
    }

    protected void checkAssessmentState() throws Exception {
        PantherAssessmentState pantherAssessmentState = this.xpass.getAssessmentState();
        if (pantherAssessmentState == null) {
            throw new XPassUnavailableException("Null return while checking assessment state");
        }
        if (pantherAssessmentState.isSubmitted()) {
            throw new ApplicationError.AssessmentComplete();
        }
    }

    protected void checkPacketTracerVersion(Result result) {
        String string = null;
        try {
            string = this.packetTracer.getVersion();
            result.getMostRecentSittingStart().setPtVersion(string);
        }
        catch (Throwable throwable) {
            pse.util.general.Utilities.check(throwable);
        }
        try {
            if (this.minimumPtVersionSpecific != null && this.minimumPtVersionSpecific.trim().length() > 0) {
                boolean bl = false;
                if (string == null) {
                    return;
                }
                Utilities.logPrintln("\n\nPT Version = <" + string + ">\n");
                if (PacketTracerUtils.getMajorVersion(string) < PacketTracerUtils.getMajorVersion(this.minimumPtVersionSpecific)) {
                    bl = true;
                } else if (PacketTracerUtils.getMajorVersion(string) == PacketTracerUtils.getMajorVersion(this.minimumPtVersionSpecific)) {
                    if (PacketTracerUtils.getMinorVersion(string) < PacketTracerUtils.getMinorVersion(this.minimumPtVersionSpecific)) {
                        bl = true;
                    } else if (PacketTracerUtils.getMinorVersion(string) == PacketTracerUtils.getMinorVersion(this.minimumPtVersionSpecific) && PacketTracerUtils.getPatchVersion(string) < PacketTracerUtils.getPatchVersion(this.minimumPtVersionSpecific)) {
                        bl = true;
                    }
                }
                if (bl) {
                    if (this.isContinued) {
                        throw new ApplicationError.PacketTracerVersionReducedError(string, this.minimumPtVersionSpecific);
                    }
                    throw new ApplicationError.HigherMinimumPtVersionError(string, this.minimumPtVersionSpecific);
                }
            }
        }
        catch (Throwable throwable) {
            pse.util.general.Utilities.checkSwallow(throwable);
        }
    }

    protected void closePacketTracer() {
        this.packetTracerClosed = true;
        if (this.packetTracerWatcher != null) {
            this.packetTracerWatcher.halt();
        }
        if (this.packetTracer != null && this.packetTracer.isUp()) {
            try {
                this.packetTracer.shutDown();
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.checkSwallow(throwable);
                try {
                    this.packetTracer.enableClose();
                }
                catch (Throwable throwable2) {
                    pse.util.general.Utilities.check(throwable2);
                }
            }
        }
        this.packetTracer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean confirm(String string, String[] stringArray) {
        try {
            this.showGlassPaneMessage("<h1>Warning!</h1>\n<p>There is a dialog box that requires your input.</p>\n<p >If you can't see it,click this window and the dialog box should appear.</p>\n<p>If that doesn't work, try minimizing windows until the dialog box becomes visible.</p>\n");
            JOptionPane jOptionPane = new JOptionPane(stringArray, 3, 0);
            JDialog jDialog = jOptionPane.createDialog(null, string);
            jDialog.setAlwaysOnTop(true);
            jDialog.setVisible(true);
            jDialog.toFront();
            Object object = jOptionPane.getValue();
            int n = 1;
            if (object != null && object instanceof Integer) {
                n = (Integer)object;
            }
            boolean bl = n == 0;
            return bl;
        }
        finally {
            this.hideGlassPaneMessage();
        }
    }

    protected WatcherThread createPacketTracerWatcher() {
        return new WatcherThread(){

            protected void checkAction() throws Exception {
                if (!ExamWorker.this.packetTracer.testIfUp()) {
                    this.disable();
                    ExamWorker.this.packetTracerClosed();
                }
            }
        };
    }

    protected void createTimers() {
        if (this.secondTimer != null) {
            this.secondTimer.shouldStop();
        }
        this.secondTimer = new NoTricksTimerThread(1000L){

            public void doWork(long l) {
                if (!this.stop) {
                    ExamWorker.this.secondElapsed(l);
                }
            }
        };
        this.secondTimer.setDaemon(true);
        this.secondTimer.start();
        if (this.autoSaveTimer != null) {
            this.autoSaveTimer.shouldStop();
        }
        this.autoSaveTimer = new NoTricksTimerThread(this.autoSaveIntervalInMilliseconds){

            public void doWork(long l) {
                if (!this.stop) {
                    ExamWorker.this.autoSaveElapsed(l);
                }
            }
        };
        this.autoSaveTimer.setDaemon(true);
        this.autoSaveTimer.start();
    }

    protected void destroyTimers() {
        if (this.secondTimer != null) {
            try {
                this.secondTimer.shouldStop();
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.check(throwable);
            }
            this.secondTimer = null;
        }
        if (this.autoSaveTimer != null) {
            try {
                this.autoSaveTimer.shouldStop();
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.check(throwable);
            }
            this.autoSaveTimer = null;
        }
    }

    protected void disableWidgets() {
        this.submitButton.setEnabled(false);
        this.interruptButton.setEnabled(false);
    }

    protected void exiting() {
        this.timersOn = false;
        this.exceptionsOff = true;
        this.disableWidgets();
        this.destroyTimers();
        if (this.progressBar != null) {
            this.progressBar.setVisible(false);
        }
        if (this.packetTracerAvailable()) {
            try {
                this.packetTracer.enableClose();
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.check(throwable);
            }
        }
    }

    protected boolean finalSave() throws Throwable {
        if (!this.packetTracer.isPka()) {
            return false;
        }
        this.submitProgress.startCloseSession();
        Session session = this.pantherResult.getSession();
        Calendar calendar = Calendar.getInstance();
        long l = session.getTimeAllowed();
        long l2 = this.getCurrentTimeRemaining();
        long l3 = l - l2;
        SittingEnd sittingEnd = new SittingEnd();
        sittingEnd.setClientTime(calendar);
        sittingEnd.setServerTimeForFillIn();
        sittingEnd.setTimeRemaining(l2);
        sittingEnd.setTimeUsed(l3);
        session.addEvent(sittingEnd);
        SessionEnd sessionEnd = new SessionEnd();
        sessionEnd.setClientTime(calendar);
        sessionEnd.setServerTimeForFillIn();
        sessionEnd.setTimeRemaining(l2);
        sessionEnd.setTimeUsed(l3);
        session.addEvent(sessionEnd);
        this.submitProgress.finishCloseSession();
        PantherEngine pantherEngine = new PantherEngine();
        Result result = pantherEngine.extractResult(session, this.startingLog, this.packetTracer, this.submitProgress);
        this.submitNeedsPt = false;
        if (result == null) {
            this.submitProgress.startXmlGeneration();
            String string = this.pantherResult.toXmlStringWithDocType();
            this.submitProgress.finishXmlGeneration();
            this.submitProgress.startXmlSubmission();
            try {
                this.xpass.putUnscorableXml(string);
            }
            catch (Throwable throwable) {
                this.reThrowXPassThrowable(throwable);
            }
            this.submitProgress.finishXmlSubmission();
        } else {
            this.submitProgress.startXmlGeneration();
            String string = result.toXmlStringWithDocType();
            this.submitProgress.finishXmlGeneration();
            this.submitProgress.startXmlSubmission();
            try {
                this.xpass.putFinalXml(string);
            }
            catch (Throwable throwable) {
                this.reThrowXPassThrowable(throwable);
            }
            this.submitProgress.finishXmlSubmission();
        }
        return result != null;
    }

    protected long getCurrentTimeRemaining() {
        return this.timeRemainingAtStart - this.timeElapsedDuringThisSession;
    }

    protected String getParameter(String string) {
        return this.applet.getParameter(string);
    }

    protected String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        return string3 == null ? string2 : string3;
    }

    protected void handleTopLevelThrowable(Throwable throwable) {
        Utilities.logPrintln("Enter handleTopLevelThrowable on " + throwable);
        if (this.exceptionsOff) {
            Utilities.logPrintln("\thandleTopLevelThrowable exceptionsOff, returning");
            return;
        }
        try {
            pse.util.general.Utilities.checkSwallow(throwable);
        }
        catch (Throwable throwable2) {
            Utilities.logPrintln("Error in checkSwallow: " + throwable2);
            pse.util.general.Utilities.check(throwable2);
        }
        String string = "";
        HashMap<String, String> hashMap = null;
        if (throwable instanceof PTSessionClosedError) {
            Utilities.logPrintln("\thandleTopLevelThrowable packetTracerClosed");
            this.packetTracerClosed();
            return;
        }
        if (throwable instanceof XPassUnavailableException) {
            Utilities.logPrintln("\thandleTopLevelThrowable xpassUnavailable");
            this.xpassUnavailable(throwable);
            return;
        }
        if (throwable instanceof ApplicationError.AppletOvertaken) {
            string = "appletovertaken";
        } else if (throwable instanceof ApplicationError.AssessmentComplete) {
            string = "assessmentcomplete";
        } else if (throwable instanceof ApplicationError.GetSessionXml) {
            string = "getsessionxml";
        } else if (throwable instanceof ApplicationError.HigherMinimumPtVersionError) {
            string = "higherptversion";
            ApplicationError.HigherMinimumPtVersionError higherMinimumPtVersionError = (ApplicationError.HigherMinimumPtVersionError)throwable;
            hashMap = new HashMap<String, String>();
            hashMap.put("currentptversion", higherMinimumPtVersionError.getCurrentPtVersion());
            hashMap.put("requiredptversion", higherMinimumPtVersionError.getRequiredPtVersion());
        } else if (throwable instanceof ApplicationError.IpcError) {
            string = "ipcerror";
        } else if (throwable instanceof ApplicationError.NoIpcPort) {
            string = "noipcport";
        } else if (throwable instanceof ApplicationError.NoPka) {
            string = "nopka";
        } else if (throwable instanceof ApplicationError.PacketTracerConnectTimeOut) {
            string = "ptconnecttimeout";
        } else if (throwable instanceof ApplicationError.PacketTracerLaunch) {
            string = "ptlaunch";
        } else if (throwable instanceof ApplicationError.PacketTracerVersionProblem) {
            string = "ptversionproblem";
        } else if (throwable instanceof ApplicationError.PacketTracerVersionReducedError) {
            string = "ptversionreducedsinceautosave";
            ApplicationError.PacketTracerVersionReducedError packetTracerVersionReducedError = (ApplicationError.PacketTracerVersionReducedError)throwable;
            hashMap = new HashMap();
            hashMap.put("currentptversion", packetTracerVersionReducedError.getCurrentPtVersion());
            hashMap.put("requiredptversion", packetTracerVersionReducedError.getRequiredPtVersion());
        } else {
            string = throwable instanceof ApplicationError.ParameterProcessing ? "parameterprocessing" : (throwable instanceof ApplicationError.PkaVersion ? "pkaversion" : (throwable instanceof ApplicationError.PutSessionXml ? "putsessionxml" : (throwable instanceof ApplicationError.SaveXmlCreation ? "savexmlcreation" : (throwable instanceof ApplicationError.SaveXmlPosting ? "savexmlposting" : (throwable instanceof ApplicationError.SubmissionError ? "submission" : "unknownjavaerror")))));
        }
        Utilities.logPrintln("\thandleTopLevelThrowable errorType = " + string);
        this.simpleError(string, throwable, hashMap);
    }

    protected void hideGlassPaneMessage() {
        this.overlayMessagePane.setText("");
        this.applet.getGlassPane().setVisible(false);
    }

    protected Result initializeResult(String string) throws Exception {
        Result result = new Result();
        try {
            result.read("Downloaded XML", string);
        }
        catch (Throwable throwable) {
            throw new Error("Unable to parse session XML", throwable);
        }
        this.startingLog = result.getOrCreateWorkProduct().getOrCreateIosLog();
        JreInfo jreInfo = JreInfo.soleInstance();
        SittingStart sittingStart = result.getSession().getLatestSittingStart();
        sittingStart.setBrowserName(jreInfo.browserName().getDynamicValue());
        sittingStart.setBrowserVersion(jreInfo.browserVersion().getDynamicValue());
        sittingStart.setOsName(jreInfo.osName().getDynamicValue());
        sittingStart.setOsVersion(jreInfo.osVersion().getDynamicValue());
        sittingStart.setPtHome(jreInfo.ptDirectory().getDynamicValue());
        sittingStart.setPtVersion(jreInfo.ptVersion().getDynamicValue());
        return result;
    }

    protected void interrupt() {
        this.timersOn = false;
        this.disableWidgets();
        this.destroyTimers();
        this.timeLabel.setText("Interrupting work, please wait...");
        Thread thread = new Thread(){

            public void run() {
                ExamWorker.this.interruptPacketTracer();
            }
        };
        thread.start();
    }

    protected void interruptPacketTracer() {
        try {
            this.interruptProgress = new InterruptProgressImpl(this.progressBar);
            this.interruptProgress.begin();
            this.progressBar.setVisible(true);
            this.interruptProgress.startInterruptingAssessment();
            Utilities.logPrintln("before checkAssessmentState");
            this.checkAssessmentState();
            Utilities.logPrintln("after checkAssessmentState");
            this.interruptProgress.finishInterruptingAssessment();
            this.interruptProgress.startDisablePacketTracer();
            this.packetTracer.disableInterface();
            this.interruptProgress.finishDisablePacketTracer();
            this.interruptSave(this.interruptProgress);
            this.finalSaveDone = true;
            this.interruptProgress.startClosePacketTracer();
            this.closePacketTracer();
            this.submittedSuccessfully = true;
            this.interruptProgress.startClosePacketTracer();
            this.interruptProgress.startEndAssessment();
            this.exiting();
            this.addPreSubmitDelay();
            this.interruptProgress.finishEndAssessment();
            this.interruptProgress.end();
            this.progressBar.setVisible(false);
            this.applet.getAppletContext().showDocument(this.xpass.getInterruptedURL());
        }
        catch (Throwable throwable) {
            Utilities.logPrintln("Throwable in interrupt() - " + throwable);
            this.handleTopLevelThrowable(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interruptSave(InterruptProgress interruptProgress) throws Throwable {
        if (!this.packetTracer.isPka()) {
            return;
        }
        interruptProgress.startCloseSession();
        Session session = this.pantherResult.getSession();
        Calendar calendar = Calendar.getInstance();
        long l = session.getTimeAllowed();
        long l2 = this.getCurrentTimeRemaining();
        long l3 = l - l2;
        SittingEnd sittingEnd = new SittingEnd();
        sittingEnd.setClientTime(calendar);
        sittingEnd.setServerTimeForFillIn();
        sittingEnd.setTimeRemaining(l2);
        sittingEnd.setTimeUsed(l3);
        interruptProgress.finishCloseSession();
        IosLog iosLog = this.packetTracer.getIosLog(interruptProgress, this.startingLog);
        interruptProgress.startWorkProductExtractionBytes();
        byte[] byArray = this.packetTracer.extractBytes();
        interruptProgress.finishWorkProductExtractionBytes();
        String string = null;
        Result result = this.pantherResult;
        synchronized (result) {
            this.pantherResult.noteAutoSave(byArray, iosLog, Calendar.getInstance());
            session.addEvent(sittingEnd);
            interruptProgress.startXmlGeneration();
            string = this.pantherResult.toXmlStringWithDocType();
            interruptProgress.finishXmlGeneration();
            this.pantherResult.getWorkProduct().setIosLog(this.startingLog);
        }
        interruptProgress.startXmlSubmission();
        try {
            this.xpass.putAutoSaveXml(string, true);
        }
        catch (Throwable throwable) {
            this.reThrowXPassThrowable(throwable);
        }
        interruptProgress.finishXmlSubmission();
    }

    protected void launchPacketTracer() {
        try {
            boolean bl;
            this.exceptionsOff = false;
            this.launchProgress = new LaunchProgressImpl(this.progressBar);
            this.launchProgress.begin();
            this.progressBar.setVisible(true);
            this.addOptionalDelay("DELAY -- Before getting initial assessment state");
            this.launchProgress.startLaunchingAssessment();
            this.checkAssessmentState();
            this.launchProgress.finishLaunchingAssessment();
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ExamWorker.this.applet.repaint();
                }
            });
            this.addOptionalDelay("DELAY -- Before downloading user's Panther assessment XML");
            this.launchProgress.startGetSessionInfo();
            String string = null;
            try {
                Utilities.logPrintln("ExamWorker - begin getSessionXml()");
                string = this.xpass.getSessionXml();
                Utilities.logPrintln("ExamWorker - end getSessionXml()");
            }
            catch (Throwable throwable) {
                Utilities.logPrintln("ExamWorker t = " + throwable);
                this.reThrowXPassThrowable(throwable);
            }
            this.launchProgress.finishGetSessionInfo();
            this.launchProgress.startInitializeResult();
            this.pantherResult = this.initializeResult(string);
            this.timeRemainingAtStart = this.pantherResult.getTimeRemaining();
            this.timeElapsedDuringThisSession = 0L;
            this.timeLabel.setText("Time Remaining: " + pse.util.general.Utilities.formatMillisecondsAsTimeString(this.timeRemainingAtStart));
            this.launchProgress.finishInitializeResult();
            this.launchProgress.startFindIpcPort();
            int n = PacketTracer.findOpenIpcPort(39000);
            this.launchProgress.finishFindIpcPort();
            if (n <= 0) {
                throw new ApplicationError.NoIpcPort();
            }
            this.packetTracer = new PacketTracer("localhost", n, false);
            this.launchProgress.startLaunchPacketTracer();
            this.packetTracer.launch(this.applet.getLocator());
            this.launchProgress.finishLaunchPacketTracer();
            this.launchProgress.startConnectPacketTracer();
            this.packetTracer.connect();
            this.packetTracerClosed = false;
            this.launchProgress.finishConnectPacketTracer();
            this.launchProgress.startDisablePacketTracer();
            this.packetTracer.disableInterface();
            this.checkPacketTracerVersion(this.pantherResult);
            this.launchProgress.finishDisablePacketTracer();
            this.launchProgress.startLoadPka();
            byte[] byArray = null;
            try {
                byArray = this.pantherResult.getLatestPkaBytes();
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.check(throwable);
                throw new ApplicationError.NoPka(throwable);
            }
            final byte[] byArray2 = byArray;
            SimpleBlock simpleBlock = new SimpleBlock(){

                public Object evaluate() throws Exception {
                    boolean bl = ExamWorker.this.packetTracer.loadBytes(byArray2, "Academy Connection Assessment");
                    return bl;
                }
            };
            GuaranteedActionStrict guaranteedActionStrict = new GuaranteedActionStrict("Load PKA Bytes", this.maximumPkaLoadTimeInSeconds * 1000, simpleBlock, true);
            guaranteedActionStrict.run();
            if (guaranteedActionStrict.timedOut() || guaranteedActionStrict.interrupted()) {
                throw new ApplicationError.PkaVersion();
            }
            if (guaranteedActionStrict.erroredOut()) {
                Throwable throwable = guaranteedActionStrict.getThrowable();
                pse.util.general.Utilities.check(throwable);
                throw new ApplicationError.NoPka(throwable);
            }
            Boolean bl2 = (Boolean)guaranteedActionStrict.getReturnValue();
            boolean bl3 = bl = bl2 != null && bl2 != false;
            if (bl2 == null || !bl2.booleanValue()) {
                throw new ApplicationError.PkaVersion();
            }
            for (int i = 1; i <= this.maximumPkaLoadTimeInSeconds && !this.packetTracer.isPka(); ++i) {
                pse.util.general.Utilities.guaranteedSleep(1000L);
            }
            if (!this.packetTracer.isPka()) {
                throw new ApplicationError.PkaVersion();
            }
            this.launchProgress.finishLoadPka();
            this.launchProgress.startEnablePacketTracer();
            this.packetTracer.enableInterface();
            this.packetTracer.customizeInterfaceForSummativeExam();
            this.pantherResult.getSession().fillInClientTime(Calendar.getInstance());
            this.packetTracer.setCountUp(this.pantherResult.getTimeRemaining());
            this.timersOn = true;
            this.launchProgress.finishEnablePacketTracer();
            this.packetTracerWatcher.enable();
            this.launchProgress.end();
            this.progressBar.setVisible(false);
            pse.util.general.Utilities.guaranteedSleep(1000L);
            this.submitButton.setEnabled(true);
            this.interruptButton.setEnabled(true);
            this.launchCompleted = true;
        }
        catch (Throwable throwable) {
            Utilities.logPrintln("ExamWorker launch() t = " + throwable);
            this.handleTopLevelThrowable(throwable);
        }
    }

    protected boolean packetTracerAvailable() {
        return this.packetTracer != null && !this.packetTracerClosed && this.packetTracer.isUp();
    }

    protected void packetTracerClosed() {
        if ((this.submitNeedsPt || this.timersOn) && !this.packetTracerClosed) {
            this.timeLabel.setText("Lost connection to Packet Tracer ...");
            this.timersOn = false;
            this.submitNeedsPt = false;
            this.stopProgressWatchers();
            this.progressBar.setVisible(false);
            this.packetTracerClosed = true;
            this.disableWidgets();
            boolean bl = this.confirm("Warning: Packet Tracer Closed Improperly", Constants.PACKET_TRACER_CLOSED_MESSAGE);
            if (bl) {
                this.createTimers();
                this.launchPacketTracer();
            } else {
                try {
                    this.applet.getAppletContext().showDocument(this.xpass.getInterruptedURL());
                }
                catch (Throwable throwable) {
                    this.handleTopLevelThrowable(throwable);
                }
            }
        }
    }

    protected void reconnectToXpass() {
        try {
            this.showGlassPaneMessage("<h1>Warning!</h1>\n<p>There is a dialog box that requires your attention.</p>\n<p>If you can't see it,click this window and the dialog box should appear.</p>\n<p>If that doesn't work, try minimizing windows until the dialog box becomes visible.</p>\n");
            int n = 3600;
            long l = System.currentTimeMillis() + (long)(n * 1000);
            final ProgressMonitor progressMonitor = new ProgressMonitor(this.applet, "Trying to reconnect to the server ...", "Attempt #1", 0, 14400);
            TimerTask timerTask = new TimerTask(){
                protected int count = 0;

                public void run() {
                    progressMonitor.setProgress(this.count++);
                }
            };
            Timer timer = new Timer("Reconnection Timer", true);
            timer.schedule(timerTask, 1000L, 1000L);
            int n2 = 1;
            while (true) {
                progressMonitor.setNote("Attempt #" + n2++);
                boolean bl = this.xpass.reestablish();
                if (bl) {
                    timer.cancel();
                    progressMonitor.close();
                    this.init();
                    this.start();
                    return;
                }
                long l2 = System.currentTimeMillis();
                if (progressMonitor.isCanceled() || l2 >= l) {
                    timer.cancel();
                    progressMonitor.close();
                    this.exiting();
                    this.allowCloseWindow();
                    return;
                }
                ThreadUtils.guaranteedSleep(5000L);
            }
        }
        finally {
            this.hideGlassPaneMessage();
        }
    }

    protected void reThrowXPassThrowable(Throwable throwable) throws Throwable {
        pse.util.general.Utilities.check(throwable);
        if (throwable instanceof ApplicationError.AppletOvertaken || throwable instanceof ApplicationError.AssessmentComplete || throwable instanceof ApplicationError.SaveGeneration || throwable instanceof XPassUnavailableException) {
            throw throwable;
        }
        throw new XPassUnavailableException(throwable);
    }

    protected void secondElapsed(long l) {
        block7: {
            if (this.timersOn) {
                try {
                    this.timeElapsedDuringThisSession += l;
                    long l2 = this.getCurrentTimeRemaining();
                    if (l2 <= 0L) {
                        this.timeLabel.setText("Time Has Run Out");
                        if (this.timeWarningDialog != null) {
                            this.timeWarningDialog.dispose();
                            this.timeWarningDialog = null;
                        }
                        this.submit(true);
                    } else {
                        String string = pse.util.general.Utilities.formatMillisecondsAsTimeString(l2);
                        this.timeLabel.setText("Time Remaining: " + string);
                        if (l2 <= 600000L && this.warnAboutTimeRemaining) {
                            this.warnAboutTimeRemaining = false;
                            this.warnTimeLeft(string);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!this.timersOn) break block7;
                    this.handleTopLevelThrowable(throwable);
                }
            }
        }
    }

    protected void showGlassPaneMessage(String string) {
        this.overlayMessagePane.setText(string);
        this.applet.getGlassPane().setVisible(true);
    }

    protected void simpleError(String string, Throwable throwable, Map<String, String> map) {
        URL uRL = null;
        try {
            uRL = this.xpass.getGeneralErrorURL(this.applet.getDocumentBase(), string, throwable, map);
        }
        catch (Throwable throwable2) {
            pse.util.general.Utilities.check(throwable2);
        }
        this.simpleError(uRL, string, throwable, map);
    }

    protected void simpleError(URL uRL, String string, Throwable throwable, Map<String, String> map) {
        try {
            this.exiting();
        }
        catch (Throwable throwable2) {
            pse.util.general.Utilities.check(throwable2);
        }
        if (this.packetTracer != null) {
            try {
                this.packetTracer.shutDown();
            }
            catch (Throwable throwable3) {
                pse.util.general.Utilities.checkSwallow(throwable3);
            }
        }
        try {
            this.xpass.reportGeneralError(this.applet.getDocumentBase(), string, throwable, map);
        }
        catch (Throwable throwable4) {
            pse.util.general.Utilities.check(throwable4);
        }
        try {
            this.applet.getAppletContext().showDocument(uRL);
        }
        catch (Throwable throwable5) {
            pse.util.general.Utilities.check(throwable5);
            this.warn("Fatal Error", "Unable to continue processing; no way to report error: " + string + ".\nMessage ID: AP-AS-001\nError Message: " + throwable5.getMessage());
        }
    }

    protected void stopProgressWatchers() {
        if (this.interruptProgress != null) {
            this.interruptProgress.end();
        }
        if (this.launchProgress != null) {
            this.launchProgress.end();
        }
        if (this.submitProgress != null) {
            this.submitProgress.end();
        }
    }

    protected void submit(boolean bl) {
        this.submitNeedsPt = true;
        this.timersOn = false;
        this.disableWidgets();
        this.destroyTimers();
        this.timeLabel.setText("Submitting work, please wait...");
        Thread thread = new Thread(){

            public void run() {
                ExamWorker.this.submitPacketTracer();
            }
        };
        thread.start();
    }

    protected void submitPacketTracer() {
        try {
            this.submitProgress = new SubmitProgressImpl(this.progressBar);
            this.submitProgress.begin();
            this.progressBar.setVisible(true);
            this.addOptionalDelay("DELAY -- Before checking current assessment state");
            this.submitProgress.startSubmittingAssessment();
            this.checkAssessmentState();
            this.submitProgress.finishSubmittingAssessment();
            this.submitProgress.startDisablePacketTracer();
            this.packetTracer.disableInterface();
            this.submitProgress.finishDisablePacketTracer();
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ExamWorker.this.applet.repaint();
                }
            });
            this.addOptionalDelay("DELAY -- Before saving user's XML");
            boolean bl = this.finalSave();
            this.finalSaveDone = true;
            this.submitProgress.startClosePacketTracer();
            this.closePacketTracer();
            this.submittedSuccessfully = true;
            this.submitProgress.finishClosePacketTracer();
            this.submitProgress.startEndAssessment();
            this.exiting();
            this.addPreSubmitDelay();
            this.submitProgress.finishEndAssessment();
            this.submitProgress.end();
            this.progressBar.setVisible(false);
            this.applet.getAppletContext().showDocument(bl ? this.xpass.getSubmitURL() : this.xpass.getUnscorableURL());
        }
        catch (Throwable throwable) {
            this.handleTopLevelThrowable(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void warn(String string, String string2) {
        try {
            this.showGlassPaneMessage("<h1>Warning!</h1>\n<p>There is a dialog box that requires your attention.</p>\n<p>If you can't see it,click this window and the dialog box should appear.</p>\n<p>If that doesn't work, try minimizing windows until the dialog box becomes visible.</p>\n");
            JOptionPane jOptionPane = new JOptionPane(string2, 0);
            JDialog jDialog = jOptionPane.createDialog(null, string);
            jDialog.setAlwaysOnTop(true);
            jDialog.setVisible(true);
            jDialog.toFront();
        }
        finally {
            this.hideGlassPaneMessage();
        }
    }

    protected void warnNoSubmit() {
        this.warn("Work Not Submitted!", "Your exam results have not yet been submitted to Academy Connection.  You must submit them for your work to be scored and for your score to appear in your gradebook.");
    }

    protected void warnTimeLeft(final String string) {
        Thread thread = new Thread(){

            public void run() {
                String string2 = Constants.fillIn("You have only FOO1 left -- after that time passes, your results will be submitted automatically by the simulation server.\n\nPress OK to return to your activity.", string);
                JOptionPane jOptionPane = new JOptionPane(string2, 2, -1);
                ExamWorker.this.timeWarningDialog = jOptionPane.createDialog(null, "Time Warning");
                ExamWorker.this.timeWarningDialog.setVisible(true);
                ExamWorker.this.timeWarningDialog.dispose();
                ExamWorker.this.timeWarningDialog = null;
            }
        };
        thread.start();
    }

    protected boolean xpassAvailable() {
        return this.xpass != null && this.xpass.isUp();
    }

    protected void xpassUnavailable(Throwable throwable) {
        this.timeLabel.setText("Lost connection to Academy Connection ...");
        this.timersOn = false;
        this.stopProgressWatchers();
        this.progressBar.setVisible(false);
        this.disableWidgets();
        if (this.packetTracer != null) {
            try {
                this.packetTracer.shutDown();
            }
            catch (Throwable throwable2) {
                pse.util.general.Utilities.checkSwallow(throwable2);
            }
        }
        if (this.packetTracerWatcher != null) {
            try {
                this.packetTracerWatcher.halt();
            }
            catch (Throwable throwable3) {
                pse.util.general.Utilities.checkSwallow(throwable3);
            }
        }
        this.packetTracerClosed = true;
        this.packetTracer = null;
        boolean bl = this.confirm("Warning: Academy Connection Assessment Server Unavailable", Constants.XPASS_UNAVAILABLE_MESSAGE);
        if (bl) {
            this.reconnectToXpass();
        } else {
            this.exiting();
            this.allowCloseWindow();
        }
    }
}

