/*
 * Decompiled with CFR 0.152.
 */
package apiipc.ipc;

import apicore.message.IPAddress;
import apicore.message.IPV6Address;
import apicore.message.MACAddress;
import apicore.message.UUID;
import apicore.ptmp.EncodedBuffer;
import java.util.List;

public abstract class IPCParameter {
    public abstract void encode(EncodedBuffer var1);

    public static class VoidParameter
    extends IPCParameter {
        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)0);
        }
    }

    public static class UUIDParameter
    extends IPCParameter {
        protected UUID value;

        public UUIDParameter(UUID uUID) {
            this.value = uUID;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)13);
            encodedBuffer.putUUID(this.value);
        }
    }

    public static class StringParameter
    extends IPCParameter {
        protected String value;

        public StringParameter(String string) {
            this.value = string;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)8);
            encodedBuffer.putString(this.value);
        }
    }

    public static class ShortParameter
    extends IPCParameter {
        protected short value;

        public ShortParameter(short s) {
            this.value = s;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)3);
            encodedBuffer.putShort(this.value);
        }
    }

    public static class QStringParameter
    extends IPCParameter {
        protected String value;

        public QStringParameter(String string) {
            this.value = string;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)9);
            encodedBuffer.putString(this.value);
        }
    }

    public static class MACAddressParameter
    extends IPCParameter {
        protected MACAddress value;

        public MACAddressParameter(MACAddress mACAddress) {
            this.value = mACAddress;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)12);
            encodedBuffer.putMACAddress(this.value);
        }
    }

    public static class LongParameter
    extends IPCParameter {
        protected long value;

        public LongParameter(long l) {
            this.value = l;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)5);
            encodedBuffer.putLong(this.value);
        }
    }

    public static class IPV6AddressParameter
    extends IPCParameter {
        protected IPV6Address value;

        public IPV6AddressParameter(IPV6Address iPV6Address) {
            this.value = iPV6Address;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)11);
            encodedBuffer.putIPV6Address(this.value);
        }
    }

    public static class IPAddressParameter
    extends IPCParameter {
        protected IPAddress value;

        public IPAddressParameter(IPAddress iPAddress) {
            this.value = iPAddress;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)10);
            encodedBuffer.putIPAddress(this.value);
        }
    }

    public static class IntParameter
    extends IPCParameter {
        protected int value;

        public IntParameter(int n) {
            this.value = n;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)4);
            encodedBuffer.putInt(this.value);
        }
    }

    public static class DoubleParameter
    extends IPCParameter {
        protected double value;

        public DoubleParameter(double d) {
            this.value = d;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)7);
            encodedBuffer.putDouble(this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteListParameter
    extends IPCParameter {
        protected List<Byte> value;

        public ByteListParameter(List<Byte> list) {
            this.value = list;
        }

        @Override
        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByteList(this.value);
        }
    }

    public static class ByteParameter
    extends IPCParameter {
        protected byte value;

        public ByteParameter(byte by) {
            this.value = by;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)1);
            encodedBuffer.putByte(this.value);
        }
    }

    public static class BoolParameter
    extends IPCParameter {
        protected boolean value;

        public BoolParameter(boolean bl) {
            this.value = bl;
        }

        public void encode(EncodedBuffer encodedBuffer) {
            encodedBuffer.putByte((byte)2);
            encodedBuffer.putBool(this.value);
        }
    }
}

