/*
 * Decompiled with CFR 0.152.
 */
package apiipc.ipc;

import apicore.message.IPAddress;
import apicore.message.IPCErrorLTV;
import apicore.message.IPCResponseLTV;
import apicore.message.IPV6Address;
import apicore.message.LTV;
import apicore.message.MACAddress;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apicore.util.Logger;
import apicore.util.Pair;
import apiipc.generated.IPCFactory;
import apiipc.generated.enums.CommandStatus;
import apiipc.ipc.IPCCall;
import apiipc.ipc.IPCError;
import apiipc.ipc.IPCMessageLTV;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IPCObject {
    protected IPCFactory ipcFactory;
    protected PacketTracerSession packetTracerSession;
    protected IPCMessageLTV accessMessage;

    public IPCObject(IPCFactory iPCFactory, PacketTracerSession packetTracerSession, IPCMessageLTV iPCMessageLTV) {
        this.ipcFactory = iPCFactory;
        this.packetTracerSession = packetTracerSession;
        this.accessMessage = iPCMessageLTV;
    }

    public IPCFactory getFactory() {
        return this.ipcFactory;
    }

    public PacketTracerSession getPacketTracerSession() {
        return this.packetTracerSession;
    }

    public IPCMessageLTV getAccessMessage() {
        return this.accessMessage;
    }

    public String getClassName() {
        String string = this.getClassNameDirect();
        return string;
    }

    protected String getClassNameDirect() {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall("getClassName");
        iPCMessageLTV.addCall(iPCCall);
        IPCResponseLTV iPCResponseLTV = this.sendMessageWithReturn(iPCMessageLTV);
        return iPCResponseLTV == null ? null : (String)iPCResponseLTV.getObjectValue();
    }

    protected String getClassNameWithChecking(int n) {
        if (this.packetTracerSession.isShutdown()) {
            throw new Error("Packet Tracer Session shut down during call to getClassName()");
        }
        final ArrayList arrayList = new ArrayList();
        Runnable runnable = new Runnable(){

            public void run() {
                arrayList.add(IPCObject.this.getClassNameDirect());
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (arrayList.isEmpty()) {
            System.out.println("getClassName() failure on attempt #" + n);
            return this.getClassNameWithChecking(n + 1);
        }
        return (String)arrayList.get(0);
    }

    public UUID getObjectUUID() {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall("getObjectUuid");
        iPCMessageLTV.addCall(iPCCall);
        IPCResponseLTV iPCResponseLTV = this.sendMessageWithReturn(iPCMessageLTV);
        return iPCResponseLTV == null ? null : (UUID)iPCResponseLTV.getObjectValue();
    }

    protected void sendMessage(IPCMessageLTV iPCMessageLTV) {
        try {
            this.getPacketTracerSession().write(iPCMessageLTV);
        }
        catch (IOException iOException) {
            throw new IPCError("Error during send of " + iPCMessageLTV, iOException);
        }
    }

    protected IPCResponseLTV sendMessageWithReturn(IPCMessageLTV iPCMessageLTV) {
        try {
            LTV lTV = this.getPacketTracerSession().writeRead(iPCMessageLTV);
            if (lTV instanceof IPCResponseLTV) {
                Logger.info("Return value = " + lTV);
                return (IPCResponseLTV)lTV;
            }
            if (lTV instanceof IPCErrorLTV) {
                IPCErrorLTV iPCErrorLTV = (IPCErrorLTV)lTV;
                if (iPCErrorLTV.getErrorMessage().equalsIgnoreCase("IPC Cache entry")) {
                    return null;
                }
                throw new IPCError("IPC Interface Error:  [" + iPCErrorLTV.getMessageId() + "] <" + iPCErrorLTV.getErrorMessage() + ">");
            }
            throw new IPCError("IPC Interface Error:  Unrecognized response message type: " + lTV);
        }
        catch (Exception exception) {
            throw new IPCError("Error during send of " + iPCMessageLTV, exception);
        }
    }

    public IPCResponseLTV send(String string) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, boolean bl, boolean bl2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addBoolParameter(bl);
        iPCCall.addBoolParameter(bl2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, boolean bl, IPAddress iPAddress) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addBoolParameter(bl);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, double d) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addDoubleParameter(d);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, double d, double d2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addDoubleParameter(d);
        iPCCall.addDoubleParameter(d2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, int n, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIntParameter(n);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, int n, boolean bl, int n2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIntParameter(n);
        iPCCall.addBoolParameter(bl);
        iPCCall.addIntParameter(n2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, int n, int n2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, int n, int n2, double d, int n3, int n4, int n5, int n6) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCCall.addDoubleParameter(d);
        iPCCall.addIntParameter(n3);
        iPCCall.addIntParameter(n4);
        iPCCall.addIntParameter(n5);
        iPCCall.addIntParameter(n6);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, int n, int n2, double d, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCCall.addDoubleParameter(d);
        iPCCall.addQStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, int n, int n2, int n3, int n4, double d, int n5, int n6, int n7, int n8) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCCall.addIntParameter(n3);
        iPCCall.addIntParameter(n4);
        iPCCall.addDoubleParameter(d);
        iPCCall.addIntParameter(n5);
        iPCCall.addIntParameter(n6);
        iPCCall.addIntParameter(n7);
        iPCCall.addIntParameter(n8);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, int n, int n2, int n3, int n4, int n5) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCCall.addIntParameter(n3);
        iPCCall.addIntParameter(n4);
        iPCCall.addIntParameter(n5);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, int n, int n2, int n3, int n4, int n5, double d, int n6, int n7, int n8, int n9) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCCall.addIntParameter(n3);
        iPCCall.addIntParameter(n4);
        iPCCall.addIntParameter(n5);
        iPCCall.addDoubleParameter(d);
        iPCCall.addIntParameter(n6);
        iPCCall.addIntParameter(n7);
        iPCCall.addIntParameter(n8);
        iPCCall.addIntParameter(n9);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, int n, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIntParameter(n);
        iPCCall.addStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, int n, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIntParameter(n);
        iPCCall.addQStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, int n, boolean bl, int n2, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIntParameter(n);
        iPCCall.addBoolParameter(bl);
        iPCCall.addIntParameter(n2);
        iPCCall.addStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, int n, int n2, int n3, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCCall.addIntParameter(n3);
        iPCCall.addStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, int n, int n2, int n3, int n4, int n5, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCCall.addIntParameter(n3);
        iPCCall.addIntParameter(n4);
        iPCCall.addIntParameter(n5);
        iPCCall.addStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, int n, String string2, String string3) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIntParameter(n);
        iPCCall.addStringParameter(string2);
        iPCCall.addStringParameter(string3);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, IPAddress iPAddress2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIPAddressParameter(iPAddress2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, IPAddress iPAddress2, IPAddress iPAddress3) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIPAddressParameter(iPAddress2);
        iPCCall.addIPAddressParameter(iPAddress3);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, IPAddress iPAddress2, IPAddress iPAddress3, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIPAddressParameter(iPAddress2);
        iPCCall.addIPAddressParameter(iPAddress3);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, IPAddress iPAddress2, IPAddress iPAddress3, String string2, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIPAddressParameter(iPAddress2);
        iPCCall.addIPAddressParameter(iPAddress3);
        iPCCall.addStringParameter(string2);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, IPAddress iPAddress2, IPAddress iPAddress3, String string2, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIPAddressParameter(iPAddress2);
        iPCCall.addIPAddressParameter(iPAddress3);
        iPCCall.addStringParameter(string2);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, String string2, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addStringParameter(string2);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPAddress iPAddress, String string2, boolean bl, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addStringParameter(string2);
        iPCCall.addBoolParameter(bl);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPV6Address iPV6Address) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPV6AddressParameter(iPV6Address);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPV6Address iPV6Address, int n, int n2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPV6AddressParameter(iPV6Address);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, IPV6Address iPV6Address, int n, int n2, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addIPV6AddressParameter(iPV6Address);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, List<Byte> list, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addByteListParameter(list);
        iPCCall.addQStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, long l) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addLongParameter(l);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, long l, long l2, long l3, long l4) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addLongParameter(l);
        iPCCall.addLongParameter(l2);
        iPCCall.addLongParameter(l3);
        iPCCall.addLongParameter(l4);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, MACAddress mACAddress) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addMACAddressParameter(mACAddress);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, MACAddress mACAddress, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addMACAddressParameter(mACAddress);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, MACAddress mACAddress, int n, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addMACAddressParameter(mACAddress);
        iPCCall.addIntParameter(n);
        iPCCall.addStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, MACAddress mACAddress, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addMACAddressParameter(mACAddress);
        iPCCall.addStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, short s, IPAddress iPAddress, IPAddress iPAddress2, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addShortParameter(s);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIPAddressParameter(iPAddress2);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addQStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, String string2, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addQStringParameter(string2);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, String string2, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addQStringParameter(string2);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, int n, boolean bl, int n2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addIntParameter(n);
        iPCCall.addBoolParameter(bl);
        iPCCall.addIntParameter(n2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, int n, int n2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, int n, int n2, int n3, IPAddress iPAddress, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addIntParameter(n);
        iPCCall.addIntParameter(n2);
        iPCCall.addIntParameter(n3);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, int n, String string3) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addIntParameter(n);
        iPCCall.addStringParameter(string3);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, String string2, int n, String string3, String string4) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addQStringParameter(string2);
        iPCCall.addIntParameter(n);
        iPCCall.addQStringParameter(string3);
        iPCCall.addQStringParameter(string4);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, IPAddress iPAddress) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, IPAddress iPAddress, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, IPAddress iPAddress, IPAddress iPAddress2, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIPAddressParameter(iPAddress2);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, IPAddress iPAddress, IPAddress iPAddress2, String string3, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIPAddressParameter(iPAddress2);
        iPCCall.addStringParameter(string3);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, short s, short s2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addShortParameter(s);
        iPCCall.addShortParameter(s2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, String string3) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addStringParameter(string3);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, String string2, String string3) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addQStringParameter(string2);
        iPCCall.addQStringParameter(string3);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQS(String string, String string2, String string3) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addQStringParameter(string2);
        iPCCall.addStringParameter(string3);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendSQ(String string, String string2, String string3) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addQStringParameter(string3);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, String string3, boolean bl, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addStringParameter(string3);
        iPCCall.addBoolParameter(bl);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendSQ(String string, String string2, String string3, boolean bl, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addQStringParameter(string3);
        iPCCall.addBoolParameter(bl);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, String string3, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addStringParameter(string3);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, String string3, int n, MACAddress mACAddress, int n2, int n3, String string4, String string5, String string6, boolean bl, IPAddress iPAddress, IPAddress iPAddress2, IPAddress iPAddress3, IPAddress iPAddress4) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addStringParameter(string3);
        iPCCall.addIntParameter(n);
        iPCCall.addMACAddressParameter(mACAddress);
        iPCCall.addIntParameter(n2);
        iPCCall.addIntParameter(n3);
        iPCCall.addStringParameter(string4);
        iPCCall.addStringParameter(string5);
        iPCCall.addStringParameter(string6);
        iPCCall.addBoolParameter(bl);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIPAddressParameter(iPAddress2);
        iPCCall.addIPAddressParameter(iPAddress3);
        iPCCall.addIPAddressParameter(iPAddress4);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, String string3, int n, MACAddress mACAddress, int n2, String string4, boolean bl, IPAddress iPAddress, IPAddress iPAddress2, IPAddress iPAddress3, IPAddress iPAddress4) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addStringParameter(string3);
        iPCCall.addIntParameter(n);
        iPCCall.addMACAddressParameter(mACAddress);
        iPCCall.addIntParameter(n2);
        iPCCall.addStringParameter(string4);
        iPCCall.addBoolParameter(bl);
        iPCCall.addIPAddressParameter(iPAddress);
        iPCCall.addIPAddressParameter(iPAddress2);
        iPCCall.addIPAddressParameter(iPAddress3);
        iPCCall.addIPAddressParameter(iPAddress4);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, String string3, int n, String string4) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addStringParameter(string3);
        iPCCall.addIntParameter(n);
        iPCCall.addStringParameter(string4);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, String string3, String string4) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addStringParameter(string3);
        iPCCall.addStringParameter(string4);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, String string2, String string3, String string4) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addQStringParameter(string2);
        iPCCall.addQStringParameter(string3);
        iPCCall.addQStringParameter(string4);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, String string2, String string3, String string4, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addQStringParameter(string2);
        iPCCall.addQStringParameter(string3);
        iPCCall.addQStringParameter(string4);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, String string2, String string3, String string4, String string5) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addStringParameter(string2);
        iPCCall.addStringParameter(string3);
        iPCCall.addStringParameter(string4);
        iPCCall.addStringParameter(string5);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, String string2, String string3, String string4, String string5) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addQStringParameter(string2);
        iPCCall.addQStringParameter(string3);
        iPCCall.addQStringParameter(string4);
        iPCCall.addQStringParameter(string5);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQSQS(String string, String string2, String string3, String string4, String string5, int n) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addQStringParameter(string2);
        iPCCall.addStringParameter(string3);
        iPCCall.addQStringParameter(string4);
        iPCCall.addStringParameter(string5);
        iPCCall.addIntParameter(n);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, UUID uUID) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addUUIDParameter(uUID);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, UUID uUID, boolean bl) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addUUIDParameter(uUID);
        iPCCall.addBoolParameter(bl);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV send(String string, UUID uUID, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addUUIDParameter(uUID);
        iPCCall.addStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public IPCResponseLTV sendQ(String string, UUID uUID, String string2) {
        IPCMessageLTV iPCMessageLTV = new IPCMessageLTV();
        iPCMessageLTV.addCalls(this.accessMessage);
        IPCCall iPCCall = new IPCCall(string);
        iPCCall.addUUIDParameter(uUID);
        iPCCall.addQStringParameter(string2);
        iPCMessageLTV.addCall(iPCCall);
        return this.sendMessageWithReturn(iPCMessageLTV);
    }

    public boolean getBool(String string) {
        IPCResponseLTV iPCResponseLTV = this.send(string);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, boolean bl) {
        IPCResponseLTV iPCResponseLTV = this.send(string, bl);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, double d) {
        IPCResponseLTV iPCResponseLTV = this.send(string, d);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, int n, int n2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, n, n2);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, int n, String string2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, n, string2);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, IPAddress iPAddress, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPAddress, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, IPAddress iPAddress, int n, String string2, String string3) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPAddress, n, string2, string3);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, IPAddress iPAddress, IPAddress iPAddress2, IPAddress iPAddress3, String string2, boolean bl) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPAddress, iPAddress2, iPAddress3, string2, bl);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, IPAddress iPAddress, IPAddress iPAddress2, IPAddress iPAddress3, String string2, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPAddress, iPAddress2, iPAddress3, string2, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, IPV6Address iPV6Address) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPV6Address);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, IPV6Address iPV6Address, int n, int n2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPV6Address, n, n2);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, MACAddress mACAddress) {
        IPCResponseLTV iPCResponseLTV = this.send(string, mACAddress);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, MACAddress mACAddress, boolean bl) {
        IPCResponseLTV iPCResponseLTV = this.send(string, mACAddress, bl);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, MACAddress mACAddress, int n, String string2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, mACAddress, n, string2);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, MACAddress mACAddress, String string2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, mACAddress, string2);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQ(String string, int n, String string2) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, n, string2);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, IPAddress iPAddress, int n, boolean bl, int n2, String string2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPAddress, n, bl, n2, string2);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, IPV6Address iPV6Address, int n, int n2, boolean bl) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPV6Address, n, n2, bl);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQ(String string, List<Byte> list, String string2) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, list, string2);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, short s, IPAddress iPAddress, IPAddress iPAddress2, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, s, iPAddress, iPAddress2, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQ(String string, String string2) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, string2);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, boolean bl) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, bl);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQ(String string, String string2, int n) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, string2, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, int n, boolean bl, int n2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, n, bl, n2);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, int n, String string3) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, n, string3);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQ(String string, String string2, int n, String string3, String string4) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, string2, n, string3, string4);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, IPAddress iPAddress) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, iPAddress);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, IPAddress iPAddress, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, iPAddress, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, IPAddress iPAddress, IPAddress iPAddress2, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, iPAddress, iPAddress2, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, IPAddress iPAddress, IPAddress iPAddress2, String string3, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, iPAddress, iPAddress2, string3, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, String string3) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, string3);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQ(String string, String string2, String string3) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, string2, string3);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQS(String string, String string2, String string3) {
        IPCResponseLTV iPCResponseLTV = this.sendQS(string, string2, string3);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolSQ(String string, String string2, String string3) {
        IPCResponseLTV iPCResponseLTV = this.sendSQ(string, string2, string3);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, String string3, boolean bl, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, string3, bl, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, String string3, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, string3, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, String string3, int n, MACAddress mACAddress, int n2, int n3, String string4, String string5, String string6, boolean bl, IPAddress iPAddress, IPAddress iPAddress2, IPAddress iPAddress3, IPAddress iPAddress4) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, string3, n, mACAddress, n2, n3, string4, string5, string6, bl, iPAddress, iPAddress2, iPAddress3, iPAddress4);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, String string3, int n, MACAddress mACAddress, int n2, String string4, boolean bl, IPAddress iPAddress, IPAddress iPAddress2, IPAddress iPAddress3, IPAddress iPAddress4) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, string3, n, mACAddress, n2, string4, bl, iPAddress, iPAddress2, iPAddress3, iPAddress4);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, String string3, int n, String string4) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, string3, n, string4);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, String string3, String string4) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, string3, string4);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQ(String string, String string2, String string3, String string4) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, string2, string3, string4);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQ(String string, String string2, String string3, String string4, boolean bl) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, string2, string3, string4, bl);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, String string2, String string3, String string4, String string5) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, string3, string4, string5);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQ(String string, String string2, String string3, String string4, String string5) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, string2, string3, string4, string5);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQSQS(String string, String string2, String string3, String string4, String string5, int n) {
        IPCResponseLTV iPCResponseLTV = this.sendQSQS(string, string2, string3, string4, string5, n);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBool(String string, UUID uUID) {
        IPCResponseLTV iPCResponseLTV = this.send(string, uUID);
        return iPCResponseLTV.getBoolValue();
    }

    public boolean getBoolQ(String string, UUID uUID, String string2) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, uUID, string2);
        return iPCResponseLTV.getBoolValue();
    }

    public byte getByte(String string) {
        IPCResponseLTV iPCResponseLTV = this.send(string);
        return iPCResponseLTV.getByteValue();
    }

    public double getDouble(String string) {
        IPCResponseLTV iPCResponseLTV = this.send(string);
        return iPCResponseLTV.getDoubleValue();
    }

    public double getDoubleQ(String string, String string2, String string3) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, string2, string3);
        return iPCResponseLTV.getDoubleValue();
    }

    public int getInt(String string) {
        IPCResponseLTV iPCResponseLTV = this.send(string);
        return iPCResponseLTV.getIntValue();
    }

    public int getInt(String string, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, n);
        return iPCResponseLTV.getIntValue();
    }

    public int getInt(String string, IPAddress iPAddress) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPAddress);
        return iPCResponseLTV.getIntValue();
    }

    public int getInt(String string, String string2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2);
        return iPCResponseLTV.getIntValue();
    }

    public int getIntQ(String string, String string2) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, string2);
        return iPCResponseLTV.getIntValue();
    }

    public int getInt(String string, String string2, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, n);
        return iPCResponseLTV.getIntValue();
    }

    public long getLong(String string) {
        IPCResponseLTV iPCResponseLTV = this.send(string);
        return iPCResponseLTV.getLongValue();
    }

    public Object getObject(String string) {
        IPCResponseLTV iPCResponseLTV = this.send(string);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, boolean bl) {
        IPCResponseLTV iPCResponseLTV = this.send(string, bl);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, n);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObjectQ(String string, int n, int n2, double d, String string2) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, n, n2, d, string2);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, int n, int n2, double d, int n3, int n4, int n5, int n6) {
        IPCResponseLTV iPCResponseLTV = this.send(string, n, n2, d, n3, n4, n5, n6);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, int n, int n2, int n3, int n4, double d, int n5, int n6, int n7, int n8) {
        IPCResponseLTV iPCResponseLTV = this.send(string, n, n2, n3, n4, d, n5, n6, n7, n8);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, int n, int n2, int n3, int n4, int n5, double d, int n6, int n7, int n8, int n9) {
        IPCResponseLTV iPCResponseLTV = this.send(string, n, n2, n3, n4, n5, d, n6, n7, n8, n9);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, int n, String string2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, n, string2);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, IPAddress iPAddress) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPAddress);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, IPAddress iPAddress, IPAddress iPAddress2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPAddress, iPAddress2);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, IPV6Address iPV6Address) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPV6Address);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, MACAddress mACAddress) {
        IPCResponseLTV iPCResponseLTV = this.send(string, mACAddress);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, String string2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObjectQ(String string, String string2) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, string2);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, String string2, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, n);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, String string2, String string3) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, string3);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObjectQ(String string, String string2, String string3) {
        IPCResponseLTV iPCResponseLTV = this.sendQ(string, string2, string3);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, String string2, int n, int n2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, string2, n, n2);
        return iPCResponseLTV.getObjectValue();
    }

    public Object getObject(String string, UUID uUID) {
        IPCResponseLTV iPCResponseLTV = this.send(string, uUID);
        return iPCResponseLTV.getObjectValue();
    }

    public short getShort(String string) {
        IPCResponseLTV iPCResponseLTV = this.send(string);
        return iPCResponseLTV.getShortValue();
    }

    public short getShort(String string, int n) {
        IPCResponseLTV iPCResponseLTV = this.send(string, n);
        return iPCResponseLTV.getShortValue();
    }

    public short getShort(String string, int n, String string2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, n, string2);
        return iPCResponseLTV.getShortValue();
    }

    public short getShort(String string, IPAddress iPAddress, int n, int n2, int n3, int n4, int n5, String string2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPAddress, n, n2, n3, n4, n5, string2);
        return iPCResponseLTV.getShortValue();
    }

    public short getShort(String string, IPAddress iPAddress, int n, int n2, int n3, String string2) {
        IPCResponseLTV iPCResponseLTV = this.send(string, iPAddress, n, n2, n3, string2);
        return iPCResponseLTV.getShortValue();
    }

    public short getShort(String string, short s) {
        IPCResponseLTV iPCResponseLTV = this.send(string, s);
        return iPCResponseLTV.getShortValue();
    }

    protected Pair<CommandStatus, String> translateToCommandStatusStringPair(Pair<Integer, String> pair) {
        return new Pair<CommandStatus, String>(CommandStatus.fromIntValue(pair.getFirst()), pair.getSecond());
    }
}

