/*
 * Decompiled with CFR 0.152.
 */
package apiipc.ipc;

import apicore.message.LTV;
import apicore.ptmp.EncodedBuffer;
import apiipc.ipc.IPCCall;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPCMessageLTV
extends LTV {
    protected int messageId;
    protected List<IPCCall> calls = new ArrayList<IPCCall>();

    public IPCMessageLTV() {
        this.setType(100);
        this.messageId = LTV.getNextMessageId();
    }

    public IPCMessageLTV(int n) {
        this.setType(100);
        this.messageId = n;
    }

    @Override
    public boolean hasResponse() {
        return true;
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer encodedBuffer) {
        encodedBuffer.putInt(this.getType());
        encodedBuffer.putInt(this.messageId);
        for (IPCCall iPCCall : this.calls) {
            iPCCall.encode(encodedBuffer);
        }
    }

    public List<IPCCall> getCalls() {
        return this.calls;
    }

    public void addCalls(IPCMessageLTV iPCMessageLTV) {
        this.calls.addAll(iPCMessageLTV.getCalls());
    }

    public void addCall(IPCCall iPCCall) {
        this.calls.add(iPCCall);
    }
}

