/*
 * Decompiled with CFR 0.152.
 */
package apiipc.ipc;

import apicore.message.IPAddress;
import apicore.message.IPV6Address;
import apicore.message.LTVParsingError;
import apicore.message.MACAddress;
import apicore.message.UUID;
import apicore.ptmp.EncodedBuffer;
import apicore.util.Pair;
import apiipc.ipc.IPCResponseFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IPCData {
    protected IPCResponseFactory ipcResponseFactory;

    public IPCData(IPCResponseFactory iPCResponseFactory) {
        this.ipcResponseFactory = iPCResponseFactory;
    }

    public abstract void read(EncodedBuffer var1);

    protected boolean readBoolean(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)2);
        return encodedBuffer.getBool();
    }

    protected byte readByte(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)1);
        return encodedBuffer.getByte();
    }

    protected IPCData readIPCData(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)16);
        return (IPCData)this.ipcResponseFactory.createIPCResponseObject(encodedBuffer);
    }

    protected double readDouble(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)7);
        return encodedBuffer.getDouble();
    }

    protected float readFloat(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)6);
        return encodedBuffer.getFloat();
    }

    protected int readInt(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)4);
        return encodedBuffer.getInt();
    }

    protected IPAddress readIPAddress(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)10);
        return encodedBuffer.getIPAddress();
    }

    protected IPV6Address readIPV6Address(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)11);
        return encodedBuffer.getIPV6Address();
    }

    protected long readLong(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)5);
        return encodedBuffer.getLong();
    }

    protected MACAddress readMACAddress(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)12);
        return encodedBuffer.getMACAddress();
    }

    protected Pair<Object, Object> readPair(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)14);
        return this.ipcResponseFactory.getPairData(encodedBuffer);
    }

    protected short readShort(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)3);
        return encodedBuffer.getShort();
    }

    protected String readQString(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)9);
        return encodedBuffer.getString();
    }

    protected String readString(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)8);
        return encodedBuffer.getString();
    }

    protected UUID readUUID(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)13);
        return encodedBuffer.getUUID();
    }

    protected List<Object> readVector(EncodedBuffer encodedBuffer) {
        IPCData.checkType(encodedBuffer, (byte)15);
        return this.ipcResponseFactory.getVectorData(encodedBuffer);
    }

    protected static void checkType(EncodedBuffer encodedBuffer, byte by) {
        byte by2 = encodedBuffer.getByte();
        if (by2 != by) {
            System.err.println("Type mis-match while parsing IPCData: expected <" + by + ">; got <" + by2 + "> instead");
            throw new LTVParsingError("Type mis-match while parsing IPCData: expected <" + by + ">; got <" + by2 + "> instead");
        }
    }
}

