/*
 * Decompiled with CFR 0.152.
 */
package apiipc.ipc;

import apicore.message.IPAddress;
import apicore.message.IPV6Address;
import apicore.message.MACAddress;
import apicore.message.UUID;
import apicore.ptmp.EncodedBuffer;
import apiipc.ipc.IPCParameter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPCCall {
    protected String name;
    protected List<IPCParameter> parameters = new ArrayList<IPCParameter>();
    public static final IPCParameter LAST_PARAMETER = new IPCParameter.VoidParameter();

    public IPCCall(String string) {
        this.name = string;
    }

    public void encode(EncodedBuffer encodedBuffer) {
        encodedBuffer.putString(this.name);
        for (IPCParameter iPCParameter : this.parameters) {
            iPCParameter.encode(encodedBuffer);
        }
        LAST_PARAMETER.encode(encodedBuffer);
    }

    public void addBoolParameter(boolean bl) {
        this.parameters.add(new IPCParameter.BoolParameter(bl));
    }

    public void addByteParameter(byte by) {
        this.parameters.add(new IPCParameter.ByteParameter(by));
    }

    public void addByteListParameter(List<Byte> list) {
        this.parameters.add(new IPCParameter.ByteListParameter(list));
    }

    public void addDoubleParameter(double d) {
        this.parameters.add(new IPCParameter.DoubleParameter(d));
    }

    public void addIntParameter(int n) {
        this.parameters.add(new IPCParameter.IntParameter(n));
    }

    public void addIPAddressParameter(IPAddress iPAddress) {
        this.parameters.add(new IPCParameter.IPAddressParameter(iPAddress));
    }

    public void addIPV6AddressParameter(IPV6Address iPV6Address) {
        this.parameters.add(new IPCParameter.IPV6AddressParameter(iPV6Address));
    }

    public void addLongParameter(long l) {
        this.parameters.add(new IPCParameter.LongParameter(l));
    }

    public void addMACAddressParameter(MACAddress mACAddress) {
        this.parameters.add(new IPCParameter.MACAddressParameter(mACAddress));
    }

    public void addQStringParameter(String string) {
        this.parameters.add(new IPCParameter.QStringParameter(string));
    }

    public void addShortParameter(short s) {
        this.parameters.add(new IPCParameter.ShortParameter(s));
    }

    public void addStringParameter(String string) {
        this.parameters.add(new IPCParameter.StringParameter(string));
    }

    public void addUUIDParameter(UUID uUID) {
        this.parameters.add(new IPCParameter.UUIDParameter(uUID));
    }
}

