/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.RemoteNetworkEvent;
import apiipc.generated.events.RemoteNetworkEventListener;
import apiipc.generated.sim.RemoteNetwork;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteNetworkEventRegistry
extends IPCEventRegistry {
    protected Set<RemoteNetworkEventListener> globalListeners = new HashSet<RemoteNetworkEventListener>();
    protected Map<String, Set<RemoteNetworkEventListener>> specificObjectListeners = new HashMap<String, Set<RemoteNetworkEventListener>>();

    public RemoteNetworkEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "RemoteNetwork";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        RemoteNetworkEvent remoteNetworkEvent = null;
        if (string.equalsIgnoreCase("peerConnected")) {
            remoteNetworkEvent = new RemoteNetworkEvent.PeerConnected(iPCEventLTV);
        } else if (string.equalsIgnoreCase("peerDisconnected")) {
            remoteNetworkEvent = new RemoteNetworkEvent.PeerDisconnected(iPCEventLTV);
        } else {
            return;
        }
        for (RemoteNetworkEventListener object : this.globalListeners) {
            object.handleEvent(remoteNetworkEvent);
        }
        System.out.println("UUID = " + remoteNetworkEvent.objectUUID);
        Set<RemoteNetworkEventListener> set = this.specificObjectListeners.get(remoteNetworkEvent.objectUUID.toString());
        System.out.println("specificListeners  = " + set);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                RemoteNetworkEventListener remoteNetworkEventListener = (RemoteNetworkEventListener)iterator.next();
                remoteNetworkEventListener.handleEvent(remoteNetworkEvent);
            }
        }
    }

    public void addListenerFiltered(RemoteNetworkEventListener remoteNetworkEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("peerConnected");
                this.register("peerDisconnected");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(remoteNetworkEventListener);
    }

    public void addSpecificListenerFiltered(RemoteNetworkEventListener remoteNetworkEventListener, RemoteNetwork remoteNetwork, List<String> list) throws IOException {
        UUID uUID = remoteNetwork.getObjectUUID();
        String string = uUID.toString();
        System.out.println("Specific uuid = " + string);
        Set<RemoteNetworkEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<RemoteNetworkEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "peerConnected");
                this.register(uUID, "peerDisconnected");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        set.add(remoteNetworkEventListener);
        System.out.println("Specific listeners = " + set);
    }

    public void removeListenerFiltered(RemoteNetworkEventListener remoteNetworkEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.deregister("peerConnected");
                this.deregister("peerDisconnected");
                this.globalListeners.remove(remoteNetworkEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(list.get(i));
                }
            }
        }
    }

    public void removeSpecificListenerFiltered(RemoteNetworkEventListener remoteNetworkEventListener, RemoteNetwork remoteNetwork, List<String> list) throws IOException {
        UUID uUID = remoteNetwork.getObjectUUID();
        String string = uUID.toString();
        Set<RemoteNetworkEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && set.isEmpty()) {
            if (list == null) {
                this.deregister(uUID, "peerConnected");
                this.deregister(uUID, "peerDisconnected");
                set.remove(remoteNetworkEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(uUID, list.get(i));
                }
            }
        }
    }

    public void addListener(RemoteNetworkEventListener remoteNetworkEventListener) throws IOException {
        this.addListenerFiltered(remoteNetworkEventListener, null);
    }

    public void addListener(RemoteNetworkEventListener remoteNetworkEventListener, RemoteNetwork remoteNetwork) throws IOException {
        this.addSpecificListenerFiltered(remoteNetworkEventListener, remoteNetwork, null);
    }

    public void removeListener(RemoteNetworkEventListener remoteNetworkEventListener) throws IOException {
        this.removeListenerFiltered(remoteNetworkEventListener, null);
    }

    public void removeListener(RemoteNetworkEventListener remoteNetworkEventListener, RemoteNetwork remoteNetwork) throws IOException {
        this.removeSpecificListenerFiltered(remoteNetworkEventListener, remoteNetwork, null);
    }
}

