/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.PLSwitchEvent;
import apiipc.generated.events.PLSwitchEventListener;
import apiipc.generated.ui.PLSwitch;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLSwitchEventRegistry
extends IPCEventRegistry {
    protected Set<PLSwitchEventListener> globalListeners = new HashSet<PLSwitchEventListener>();
    protected Map<String, Set<PLSwitchEventListener>> specificObjectListeners = new HashMap<String, Set<PLSwitchEventListener>>();

    public PLSwitchEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "PLSwitch";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        PLSwitchEvent.ModeSwitched modeSwitched = null;
        if (!string.equalsIgnoreCase("modeSwitched")) {
            return;
        }
        modeSwitched = new PLSwitchEvent.ModeSwitched(iPCEventLTV);
        for (PLSwitchEventListener object : this.globalListeners) {
            object.handleEvent(modeSwitched);
        }
        System.out.println("UUID = " + modeSwitched.objectUUID);
        Set<PLSwitchEventListener> set = this.specificObjectListeners.get(modeSwitched.objectUUID.toString());
        System.out.println("specificListeners  = " + set);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                PLSwitchEventListener pLSwitchEventListener = (PLSwitchEventListener)iterator.next();
                pLSwitchEventListener.handleEvent(modeSwitched);
            }
        }
    }

    public void addListenerFiltered(PLSwitchEventListener pLSwitchEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("modeSwitched");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(pLSwitchEventListener);
    }

    public void addSpecificListenerFiltered(PLSwitchEventListener pLSwitchEventListener, PLSwitch pLSwitch, List<String> list) throws IOException {
        UUID uUID = pLSwitch.getObjectUUID();
        String string = uUID.toString();
        System.out.println("Specific uuid = " + string);
        Set<PLSwitchEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<PLSwitchEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "modeSwitched");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        set.add(pLSwitchEventListener);
        System.out.println("Specific listeners = " + set);
    }

    public void removeListenerFiltered(PLSwitchEventListener pLSwitchEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.deregister("modeSwitched");
                this.globalListeners.remove(pLSwitchEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(list.get(i));
                }
            }
        }
    }

    public void removeSpecificListenerFiltered(PLSwitchEventListener pLSwitchEventListener, PLSwitch pLSwitch, List<String> list) throws IOException {
        UUID uUID = pLSwitch.getObjectUUID();
        String string = uUID.toString();
        Set<PLSwitchEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && set.isEmpty()) {
            if (list == null) {
                this.deregister(uUID, "modeSwitched");
                set.remove(pLSwitchEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(uUID, list.get(i));
                }
            }
        }
    }

    public void addListener(PLSwitchEventListener pLSwitchEventListener) throws IOException {
        this.addListenerFiltered(pLSwitchEventListener, null);
    }

    public void addListener(PLSwitchEventListener pLSwitchEventListener, PLSwitch pLSwitch) throws IOException {
        this.addSpecificListenerFiltered(pLSwitchEventListener, pLSwitch, null);
    }

    public void removeListener(PLSwitchEventListener pLSwitchEventListener) throws IOException {
        this.removeListenerFiltered(pLSwitchEventListener, null);
    }

    public void removeListener(PLSwitchEventListener pLSwitchEventListener, PLSwitch pLSwitch) throws IOException {
        this.removeSpecificListenerFiltered(pLSwitchEventListener, pLSwitch, null);
    }
}

