/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.HTTPClientEvent;
import apiipc.generated.events.HTTPClientEventListener;
import apiipc.generated.sim.HTTPClient;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPClientEventRegistry
extends IPCEventRegistry {
    protected Set<HTTPClientEventListener> globalListeners = new HashSet<HTTPClientEventListener>();
    protected Map<String, Set<HTTPClientEventListener>> specificObjectListeners = new HashMap<String, Set<HTTPClientEventListener>>();

    public HTTPClientEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "HTTPClient";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        HTTPClientEvent.OnDone onDone = null;
        if (!string.equalsIgnoreCase("onDone")) {
            return;
        }
        onDone = new HTTPClientEvent.OnDone(iPCEventLTV);
        for (HTTPClientEventListener object : this.globalListeners) {
            object.handleEvent(onDone);
        }
        System.out.println("UUID = " + onDone.objectUUID);
        Set<HTTPClientEventListener> set = this.specificObjectListeners.get(onDone.objectUUID.toString());
        System.out.println("specificListeners  = " + set);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                HTTPClientEventListener hTTPClientEventListener = (HTTPClientEventListener)iterator.next();
                hTTPClientEventListener.handleEvent(onDone);
            }
        }
    }

    public void addListenerFiltered(HTTPClientEventListener hTTPClientEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("onDone");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(hTTPClientEventListener);
    }

    public void addSpecificListenerFiltered(HTTPClientEventListener hTTPClientEventListener, HTTPClient hTTPClient, List<String> list) throws IOException {
        UUID uUID = hTTPClient.getObjectUUID();
        String string = uUID.toString();
        System.out.println("Specific uuid = " + string);
        Set<HTTPClientEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<HTTPClientEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "onDone");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        set.add(hTTPClientEventListener);
        System.out.println("Specific listeners = " + set);
    }

    public void removeListenerFiltered(HTTPClientEventListener hTTPClientEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.deregister("onDone");
                this.globalListeners.remove(hTTPClientEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(list.get(i));
                }
            }
        }
    }

    public void removeSpecificListenerFiltered(HTTPClientEventListener hTTPClientEventListener, HTTPClient hTTPClient, List<String> list) throws IOException {
        UUID uUID = hTTPClient.getObjectUUID();
        String string = uUID.toString();
        Set<HTTPClientEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && set.isEmpty()) {
            if (list == null) {
                this.deregister(uUID, "onDone");
                set.remove(hTTPClientEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(uUID, list.get(i));
                }
            }
        }
    }

    public void addListener(HTTPClientEventListener hTTPClientEventListener) throws IOException {
        this.addListenerFiltered(hTTPClientEventListener, null);
    }

    public void addListener(HTTPClientEventListener hTTPClientEventListener, HTTPClient hTTPClient) throws IOException {
        this.addSpecificListenerFiltered(hTTPClientEventListener, hTTPClient, null);
    }

    public void removeListener(HTTPClientEventListener hTTPClientEventListener) throws IOException {
        this.removeListenerFiltered(hTTPClientEventListener, null);
    }

    public void removeListener(HTTPClientEventListener hTTPClientEventListener, HTTPClient hTTPClient) throws IOException {
        this.removeSpecificListenerFiltered(hTTPClientEventListener, hTTPClient, null);
    }
}

