/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.DeviceEvent;
import apiipc.generated.events.DeviceEventListener;
import apiipc.generated.sim.Device;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceEventRegistry
extends IPCEventRegistry {
    protected Set<DeviceEventListener> globalListeners = new HashSet<DeviceEventListener>();
    protected Map<String, Set<DeviceEventListener>> specificObjectListeners = new HashMap<String, Set<DeviceEventListener>>();

    public DeviceEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "Device";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        DeviceEvent deviceEvent = null;
        if (string.equalsIgnoreCase("nameChanged")) {
            deviceEvent = new DeviceEvent.NameChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("powerChanged")) {
            deviceEvent = new DeviceEvent.PowerChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("moduleAdded")) {
            deviceEvent = new DeviceEvent.ModuleAdded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("moduleRemoved")) {
            deviceEvent = new DeviceEvent.ModuleRemoved(iPCEventLTV);
        } else if (string.equalsIgnoreCase("portAdded")) {
            deviceEvent = new DeviceEvent.PortAdded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("portRemoved")) {
            deviceEvent = new DeviceEvent.PortRemoved(iPCEventLTV);
        } else {
            return;
        }
        for (DeviceEventListener object : this.globalListeners) {
            object.handleEvent(deviceEvent);
        }
        System.out.println("UUID = " + deviceEvent.objectUUID);
        Set<DeviceEventListener> set = this.specificObjectListeners.get(deviceEvent.objectUUID.toString());
        System.out.println("specificListeners  = " + set);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                DeviceEventListener deviceEventListener = (DeviceEventListener)iterator.next();
                deviceEventListener.handleEvent(deviceEvent);
            }
        }
    }

    public void addListenerFiltered(DeviceEventListener deviceEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("nameChanged");
                this.register("powerChanged");
                this.register("moduleAdded");
                this.register("moduleRemoved");
                this.register("portAdded");
                this.register("portRemoved");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(deviceEventListener);
    }

    public void addSpecificListenerFiltered(DeviceEventListener deviceEventListener, Device device, List<String> list) throws IOException {
        UUID uUID = device.getObjectUUID();
        String string = uUID.toString();
        System.out.println("Specific uuid = " + string);
        Set<DeviceEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<DeviceEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "nameChanged");
                this.register(uUID, "powerChanged");
                this.register(uUID, "moduleAdded");
                this.register(uUID, "moduleRemoved");
                this.register(uUID, "portAdded");
                this.register(uUID, "portRemoved");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        set.add(deviceEventListener);
        System.out.println("Specific listeners = " + set);
    }

    public void removeListenerFiltered(DeviceEventListener deviceEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.deregister("nameChanged");
                this.deregister("powerChanged");
                this.deregister("moduleAdded");
                this.deregister("moduleRemoved");
                this.deregister("portAdded");
                this.deregister("portRemoved");
                this.globalListeners.remove(deviceEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(list.get(i));
                }
            }
        }
    }

    public void removeSpecificListenerFiltered(DeviceEventListener deviceEventListener, Device device, List<String> list) throws IOException {
        UUID uUID = device.getObjectUUID();
        String string = uUID.toString();
        Set<DeviceEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && set.isEmpty()) {
            if (list == null) {
                this.deregister(uUID, "nameChanged");
                this.deregister(uUID, "powerChanged");
                this.deregister(uUID, "moduleAdded");
                this.deregister(uUID, "moduleRemoved");
                this.deregister(uUID, "portAdded");
                this.deregister(uUID, "portRemoved");
                set.remove(deviceEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(uUID, list.get(i));
                }
            }
        }
    }

    public void addListener(DeviceEventListener deviceEventListener) throws IOException {
        this.addListenerFiltered(deviceEventListener, null);
    }

    public void addListener(DeviceEventListener deviceEventListener, Device device) throws IOException {
        this.addSpecificListenerFiltered(deviceEventListener, device, null);
    }

    public void removeListener(DeviceEventListener deviceEventListener) throws IOException {
        this.removeListenerFiltered(deviceEventListener, null);
    }

    public void removeListener(DeviceEventListener deviceEventListener, Device device) throws IOException {
        this.removeSpecificListenerFiltered(deviceEventListener, device, null);
    }
}

