/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apiipc.generated.enums.ModuleType;
import apiipc.ipc.IPCEvent;

public abstract class DeviceEvent
extends IPCEvent {
    public EventType type;

    public DeviceEvent(IPCEventLTV iPCEventLTV) {
        super(iPCEventLTV);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        NAME_CHANGED,
        POWER_CHANGED,
        MODULE_ADDED,
        MODULE_REMOVED,
        PORT_ADDED,
        PORT_REMOVED;

    }

    public static class PortRemoved
    extends DeviceEvent {
        public String portName;

        public PortRemoved(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.PORT_REMOVED;
            this.portName = (String)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tportName = " + this.portName;
        }
    }

    public static class PortAdded
    extends DeviceEvent {
        public String portName;

        public PortAdded(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.PORT_ADDED;
            this.portName = (String)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tportName = " + this.portName;
        }
    }

    public static class ModuleRemoved
    extends DeviceEvent {
        public ModuleType inType;
        public String model;

        public ModuleRemoved(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.MODULE_REMOVED;
            this.inType = ModuleType.fromIntValue((Integer)iPCEventLTV.getEventParameters().get(0));
            this.model = (String)iPCEventLTV.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tinType = " + (Object)((Object)this.inType) + "\n\tmodel = " + this.model;
        }
    }

    public static class ModuleAdded
    extends DeviceEvent {
        public ModuleType inType;
        public String model;

        public ModuleAdded(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.MODULE_ADDED;
            this.inType = ModuleType.fromIntValue((Integer)iPCEventLTV.getEventParameters().get(0));
            this.model = (String)iPCEventLTV.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tinType = " + (Object)((Object)this.inType) + "\n\tmodel = " + this.model;
        }
    }

    public static class PowerChanged
    extends DeviceEvent {
        public Boolean on;

        public PowerChanged(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.POWER_CHANGED;
            this.on = (Boolean)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\ton = " + this.on;
        }
    }

    public static class NameChanged
    extends DeviceEvent {
        public String newName;
        public String oldName;

        public NameChanged(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.NAME_CHANGED;
            this.newName = (String)iPCEventLTV.getEventParameters().get(0);
            this.oldName = (String)iPCEventLTV.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tnewName = " + this.newName + "\n\toldName = " + this.oldName;
        }
    }
}

