/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPAddress;
import apicore.message.IPCEventLTV;
import apiipc.ipc.IPCEvent;

public abstract class DHCPClientProcessEvent
extends IPCEvent {
    public EventType type;

    public DHCPClientProcessEvent(IPCEventLTV iPCEventLTV) {
        super(iPCEventLTV);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        DHCP_SUCCEED,
        DHCP_CONFIGURED,
        DHCP_FAILED;

    }

    public static class DhcpFailed
    extends DHCPClientProcessEvent {
        public String deviceName;
        public String portName;

        public DhcpFailed(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.DHCP_FAILED;
            this.deviceName = (String)iPCEventLTV.getEventParameters().get(0);
            this.portName = (String)iPCEventLTV.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tdeviceName = " + this.deviceName + "\n\tportName = " + this.portName;
        }
    }

    public static class DhcpConfigured
    extends DHCPClientProcessEvent {
        public String deviceName;
        public String portName;
        public Boolean isConfigured;

        public DhcpConfigured(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.DHCP_CONFIGURED;
            this.deviceName = (String)iPCEventLTV.getEventParameters().get(0);
            this.portName = (String)iPCEventLTV.getEventParameters().get(1);
            this.isConfigured = (Boolean)iPCEventLTV.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tdeviceName = " + this.deviceName + "\n\tportName = " + this.portName + "\n\tisConfigured = " + this.isConfigured;
        }
    }

    public static class DhcpSucceed
    extends DHCPClientProcessEvent {
        public String deviceName;
        public String portName;
        public IPAddress newip;
        public IPAddress newmask;

        public DhcpSucceed(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.DHCP_SUCCEED;
            this.deviceName = (String)iPCEventLTV.getEventParameters().get(0);
            this.portName = (String)iPCEventLTV.getEventParameters().get(1);
            this.newip = (IPAddress)iPCEventLTV.getEventParameters().get(2);
            this.newmask = (IPAddress)iPCEventLTV.getEventParameters().get(3);
        }

        public String toString() {
            return super.toString() + "\n\tdeviceName = " + this.deviceName + "\n\tportName = " + this.portName + "\n\tnewip = " + this.newip + "\n\tnewmask = " + this.newmask;
        }
    }
}

