/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPAddress;
import apicore.message.IPCEventLTV;
import apiipc.generated.enums.LoginMethod;
import apiipc.ipc.IPCEvent;

public abstract class CiscoDeviceEvent
extends IPCEvent {
    public EventType type;

    public CiscoDeviceEvent(IPCEventLTV iPCEventLTV) {
        super(iPCEventLTV);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        DONE_BOOTING,
        LINE_CONNECTED,
        LINE_DISCONNECTED,
        LINE_AUTHENTICATION_STARTED,
        LINE_AUTHENTICATION_FAILED,
        LINE_AUTHENTICATION_FINISHED;

    }

    public static class LineAuthenticationFinished
    extends CiscoDeviceEvent {
        public Integer lineNum;
        public Boolean success;

        public LineAuthenticationFinished(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.LINE_AUTHENTICATION_FINISHED;
            this.lineNum = (Integer)iPCEventLTV.getEventParameters().get(0);
            this.success = (Boolean)iPCEventLTV.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum + "\n\tsuccess = " + this.success;
        }
    }

    public static class LineAuthenticationFailed
    extends CiscoDeviceEvent {
        public Integer lineNum;

        public LineAuthenticationFailed(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.LINE_AUTHENTICATION_FAILED;
            this.lineNum = (Integer)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum;
        }
    }

    public static class LineAuthenticationStarted
    extends CiscoDeviceEvent {
        public Integer lineNum;
        public IPAddress srcIp;
        public Short srcTcpPort;
        public LoginMethod loginMethod;

        public LineAuthenticationStarted(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.LINE_AUTHENTICATION_STARTED;
            this.lineNum = (Integer)iPCEventLTV.getEventParameters().get(0);
            this.srcIp = (IPAddress)iPCEventLTV.getEventParameters().get(1);
            this.srcTcpPort = (Short)iPCEventLTV.getEventParameters().get(2);
            this.loginMethod = (LoginMethod)((Object)iPCEventLTV.getEventParameters().get(3));
        }

        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum + "\n\tsrcIp = " + this.srcIp + "\n\tsrcTcpPort = " + this.srcTcpPort + "\n\tloginMethod = " + (Object)((Object)this.loginMethod);
        }
    }

    public static class LineDisconnected
    extends CiscoDeviceEvent {
        public Integer lineNum;

        public LineDisconnected(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.LINE_DISCONNECTED;
            this.lineNum = (Integer)iPCEventLTV.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum;
        }
    }

    public static class LineConnected
    extends CiscoDeviceEvent {
        public Integer lineNum;
        public IPAddress srcIp;
        public Short srcTcpPort;
        public LoginMethod loginMethod;

        public LineConnected(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.LINE_CONNECTED;
            this.lineNum = (Integer)iPCEventLTV.getEventParameters().get(0);
            this.srcIp = (IPAddress)iPCEventLTV.getEventParameters().get(1);
            this.srcTcpPort = (Short)iPCEventLTV.getEventParameters().get(2);
            this.loginMethod = (LoginMethod)((Object)iPCEventLTV.getEventParameters().get(3));
        }

        public String toString() {
            return super.toString() + "\n\tlineNum = " + this.lineNum + "\n\tsrcIp = " + this.srcIp + "\n\tsrcTcpPort = " + this.srcTcpPort + "\n\tloginMethod = " + (Object)((Object)this.loginMethod);
        }
    }

    public static class DoneBooting
    extends CiscoDeviceEvent {
        public DoneBooting(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.DONE_BOOTING;
        }

        public String toString() {
            return super.toString();
        }
    }
}

