/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.CepInstanceEvent;
import apiipc.generated.events.CepInstanceEventListener;
import apiipc.generated.system.CepInstance;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CepInstanceEventRegistry
extends IPCEventRegistry {
    protected Set<CepInstanceEventListener> globalListeners = new HashSet<CepInstanceEventListener>();
    protected Map<String, Set<CepInstanceEventListener>> specificObjectListeners = new HashMap<String, Set<CepInstanceEventListener>>();

    public CepInstanceEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "CepInstance";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        CepInstanceEvent cepInstanceEvent = null;
        if (string.equalsIgnoreCase("messageReceived")) {
            cepInstanceEvent = new CepInstanceEvent.MessageReceived(iPCEventLTV);
        } else if (string.equalsIgnoreCase("remoteMessageReceived")) {
            cepInstanceEvent = new CepInstanceEvent.RemoteMessageReceived(iPCEventLTV);
        } else {
            return;
        }
        for (CepInstanceEventListener object : this.globalListeners) {
            object.handleEvent(cepInstanceEvent);
        }
        Set<CepInstanceEventListener> set = this.specificObjectListeners.get(cepInstanceEvent.objectUUID.toString());
        if (set != null) {
            for (CepInstanceEventListener cepInstanceEventListener : set) {
                cepInstanceEventListener.handleEvent(cepInstanceEvent);
            }
        }
    }

    public void addListenerFiltered(CepInstanceEventListener cepInstanceEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("messageReceived");
                this.register("remoteMessageReceived");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(cepInstanceEventListener);
    }

    public void addSpecificListenerFiltered(CepInstanceEventListener cepInstanceEventListener, CepInstance cepInstance, List<String> list) throws IOException {
        UUID uUID = cepInstance.getObjectUUID();
        String string = uUID.toString();
        System.out.println("Specific uuid = " + string);
        Set<CepInstanceEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<CepInstanceEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "messageReceived");
                this.register(uUID, "remoteMessageReceived");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        set.add(cepInstanceEventListener);
        System.out.println("Specific listeners = " + set);
    }

    public void removeListenerFiltered(CepInstanceEventListener cepInstanceEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.deregister("messageReceived");
                this.deregister("remoteMessageReceived");
                this.globalListeners.remove(cepInstanceEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(list.get(i));
                }
            }
        }
    }

    public void removeSpecificListenerFiltered(CepInstanceEventListener cepInstanceEventListener, CepInstance cepInstance, List<String> list) throws IOException {
        UUID uUID = cepInstance.getObjectUUID();
        String string = uUID.toString();
        Set<CepInstanceEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && set.isEmpty()) {
            if (list == null) {
                this.deregister(uUID, "messageReceived");
                this.deregister(uUID, "remoteMessageReceived");
                set.remove(cepInstanceEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(uUID, list.get(i));
                }
            }
        }
    }

    public void addListener(CepInstanceEventListener cepInstanceEventListener) throws IOException {
        this.addListenerFiltered(cepInstanceEventListener, null);
    }

    public void addListener(CepInstanceEventListener cepInstanceEventListener, CepInstance cepInstance) throws IOException {
        this.addSpecificListenerFiltered(cepInstanceEventListener, cepInstance, null);
    }

    public void removeListener(CepInstanceEventListener cepInstanceEventListener) throws IOException {
        this.removeListenerFiltered(cepInstanceEventListener, null);
    }

    public void removeListener(CepInstanceEventListener cepInstanceEventListener, CepInstance cepInstance) throws IOException {
        this.removeSpecificListenerFiltered(cepInstanceEventListener, cepInstance, null);
    }
}

