/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.AppWindowEvent;
import apiipc.generated.events.AppWindowEventListener;
import apiipc.generated.ui.AppWindow;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppWindowEventRegistry
extends IPCEventRegistry {
    protected Set<AppWindowEventListener> globalListeners = new HashSet<AppWindowEventListener>();
    protected Map<String, Set<AppWindowEventListener>> specificObjectListeners = new HashMap<String, Set<AppWindowEventListener>>();

    public AppWindowEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "AppWindow";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        AppWindowEvent appWindowEvent = null;
        if (string.equalsIgnoreCase("fileNewed")) {
            appWindowEvent = new AppWindowEvent.FileNewed(iPCEventLTV);
        } else if (string.equalsIgnoreCase("fileOpened")) {
            appWindowEvent = new AppWindowEvent.FileOpened(iPCEventLTV);
        } else if (string.equalsIgnoreCase("fileSaved")) {
            appWindowEvent = new AppWindowEvent.FileSaved(iPCEventLTV);
        } else if (string.equalsIgnoreCase("fileSaveDone")) {
            appWindowEvent = new AppWindowEvent.FileSaveDone(iPCEventLTV);
        } else if (string.equalsIgnoreCase("fileSaveToBytesDone")) {
            appWindowEvent = new AppWindowEvent.FileSaveToBytesDone(iPCEventLTV);
        } else {
            return;
        }
        for (AppWindowEventListener object : this.globalListeners) {
            object.handleEvent(appWindowEvent);
        }
        System.out.println("UUID = " + appWindowEvent.objectUUID);
        Set<AppWindowEventListener> set = this.specificObjectListeners.get(appWindowEvent.objectUUID.toString());
        System.out.println("specificListeners  = " + set);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AppWindowEventListener appWindowEventListener = (AppWindowEventListener)iterator.next();
                appWindowEventListener.handleEvent(appWindowEvent);
            }
        }
    }

    public void addListenerFiltered(AppWindowEventListener appWindowEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("fileNewed");
                this.register("fileOpened");
                this.register("fileSaved");
                this.register("fileSaveDone");
                this.register("fileSaveToBytesDone");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(appWindowEventListener);
    }

    public void addSpecificListenerFiltered(AppWindowEventListener appWindowEventListener, AppWindow appWindow, List<String> list) throws IOException {
        UUID uUID = appWindow.getObjectUUID();
        String string = uUID.toString();
        System.out.println("Specific uuid = " + string);
        Set<AppWindowEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<AppWindowEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "fileNewed");
                this.register(uUID, "fileOpened");
                this.register(uUID, "fileSaved");
                this.register(uUID, "fileSaveDone");
                this.register(uUID, "fileSaveToBytesDone");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        set.add(appWindowEventListener);
        System.out.println("Specific listeners = " + set);
    }

    public void removeListenerFiltered(AppWindowEventListener appWindowEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.deregister("fileNewed");
                this.deregister("fileOpened");
                this.deregister("fileSaved");
                this.deregister("fileSaveDone");
                this.deregister("fileSaveToBytesDone");
                this.globalListeners.remove(appWindowEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(list.get(i));
                }
            }
        }
    }

    public void removeSpecificListenerFiltered(AppWindowEventListener appWindowEventListener, AppWindow appWindow, List<String> list) throws IOException {
        UUID uUID = appWindow.getObjectUUID();
        String string = uUID.toString();
        Set<AppWindowEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && set.isEmpty()) {
            if (list == null) {
                this.deregister(uUID, "fileNewed");
                this.deregister(uUID, "fileOpened");
                this.deregister(uUID, "fileSaved");
                this.deregister(uUID, "fileSaveDone");
                this.deregister(uUID, "fileSaveToBytesDone");
                set.remove(appWindowEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(uUID, list.get(i));
                }
            }
        }
    }

    public void addListener(AppWindowEventListener appWindowEventListener) throws IOException {
        this.addListenerFiltered(appWindowEventListener, null);
    }

    public void addListener(AppWindowEventListener appWindowEventListener, AppWindow appWindow) throws IOException {
        this.addSpecificListenerFiltered(appWindowEventListener, appWindow, null);
    }

    public void removeListener(AppWindowEventListener appWindowEventListener) throws IOException {
        this.removeListenerFiltered(appWindowEventListener, null);
    }

    public void removeListener(AppWindowEventListener appWindowEventListener, AppWindow appWindow) throws IOException {
        this.removeSpecificListenerFiltered(appWindowEventListener, appWindow, null);
    }
}

