/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.ARPProcessEvent;
import apiipc.generated.events.ARPProcessEventListener;
import apiipc.generated.sim.ARPProcess;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPProcessEventRegistry
extends IPCEventRegistry {
    protected Set<ARPProcessEventListener> globalListeners = new HashSet<ARPProcessEventListener>();
    protected Map<String, Set<ARPProcessEventListener>> specificObjectListeners = new HashMap<String, Set<ARPProcessEventListener>>();

    public ARPProcessEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "ARPProcess";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        ARPProcessEvent aRPProcessEvent = null;
        if (string.equalsIgnoreCase("arpEntryAdded")) {
            aRPProcessEvent = new ARPProcessEvent.ArpEntryAdded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("arpEntryRemoved")) {
            aRPProcessEvent = new ARPProcessEvent.ArpEntryRemoved(iPCEventLTV);
        } else {
            return;
        }
        for (ARPProcessEventListener object : this.globalListeners) {
            object.handleEvent(aRPProcessEvent);
        }
        System.out.println("UUID = " + aRPProcessEvent.objectUUID);
        Set<ARPProcessEventListener> set = this.specificObjectListeners.get(aRPProcessEvent.objectUUID.toString());
        System.out.println("specificListeners  = " + set);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ARPProcessEventListener aRPProcessEventListener = (ARPProcessEventListener)iterator.next();
                aRPProcessEventListener.handleEvent(aRPProcessEvent);
            }
        }
    }

    public void addListenerFiltered(ARPProcessEventListener aRPProcessEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("arpEntryAdded");
                this.register("arpEntryRemoved");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(aRPProcessEventListener);
    }

    public void addSpecificListenerFiltered(ARPProcessEventListener aRPProcessEventListener, ARPProcess aRPProcess, List<String> list) throws IOException {
        UUID uUID = aRPProcess.getObjectUUID();
        String string = uUID.toString();
        System.out.println("Specific uuid = " + string);
        Set<ARPProcessEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<ARPProcessEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "arpEntryAdded");
                this.register(uUID, "arpEntryRemoved");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        set.add(aRPProcessEventListener);
        System.out.println("Specific listeners = " + set);
    }

    public void removeListenerFiltered(ARPProcessEventListener aRPProcessEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.deregister("arpEntryAdded");
                this.deregister("arpEntryRemoved");
                this.globalListeners.remove(aRPProcessEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(list.get(i));
                }
            }
        }
    }

    public void removeSpecificListenerFiltered(ARPProcessEventListener aRPProcessEventListener, ARPProcess aRPProcess, List<String> list) throws IOException {
        UUID uUID = aRPProcess.getObjectUUID();
        String string = uUID.toString();
        Set<ARPProcessEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && set.isEmpty()) {
            if (list == null) {
                this.deregister(uUID, "arpEntryAdded");
                this.deregister(uUID, "arpEntryRemoved");
                set.remove(aRPProcessEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(uUID, list.get(i));
                }
            }
        }
    }

    public void addListener(ARPProcessEventListener aRPProcessEventListener) throws IOException {
        this.addListenerFiltered(aRPProcessEventListener, null);
    }

    public void addListener(ARPProcessEventListener aRPProcessEventListener, ARPProcess aRPProcess) throws IOException {
        this.addSpecificListenerFiltered(aRPProcessEventListener, aRPProcess, null);
    }

    public void removeListener(ARPProcessEventListener aRPProcessEventListener) throws IOException {
        this.removeListenerFiltered(aRPProcessEventListener, null);
    }

    public void removeListener(ARPProcessEventListener aRPProcessEventListener, ARPProcess aRPProcess) throws IOException {
        this.removeSpecificListenerFiltered(aRPProcessEventListener, aRPProcess, null);
    }
}

