/*
 * Decompiled with CFR 0.152.
 */
package apicore.util;

import apicore.ptmp.EncodedBuffer;

public class Utilities {
    public static final String[] BYTE_STRINGS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public static void check(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
    }

    public static byte[] decodeHex(String string) {
        String string2 = string.replaceAll("[^0-9a-fA-F]", "");
        return new byte[2];
    }

    public static String dumpRawBytes(EncodedBuffer encodedBuffer) {
        return Utilities.dumpRawBytes(encodedBuffer, true);
    }

    public static String dumpRawBytes(EncodedBuffer encodedBuffer, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = encodedBuffer.copyRawBytes(bl);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(Utilities.rightJustify(i, 5));
            stringBuilder.append("  ");
            stringBuilder.append(Utilities.rightJustify(byArray[i], 3));
            stringBuilder.append("  <");
            stringBuilder.append(Character.valueOf((char)byArray[i]));
            stringBuilder.append(">\n");
        }
        return stringBuilder.toString();
    }

    public static String dumpRawBytes(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(Utilities.rightJustify(i, 5));
            stringBuilder.append("  ");
            stringBuilder.append(Utilities.rightJustify(byArray[i], 3));
            stringBuilder.append("  <");
            stringBuilder.append(Character.valueOf((char)byArray[i]));
            stringBuilder.append(">\n");
        }
        return stringBuilder.toString();
    }

    public static String encodeColonHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            if (n < 0) {
                n += 256;
            }
            int n2 = (n &= 0xFF) % 16;
            int n3 = n / 16;
            if (i > 0) {
                stringBuilder.append(":");
            }
            stringBuilder.append(BYTE_STRINGS[n3]);
            stringBuilder.append(BYTE_STRINGS[n2]);
        }
        return stringBuilder.toString();
    }

    public static String encodeDottedHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            if (n < 0) {
                n += 256;
            }
            int n2 = (n &= 0xFF) % 16;
            int n3 = n / 16;
            if (i > 0 && i % 3 == 0) {
                stringBuilder.append(".");
            }
            stringBuilder.append(BYTE_STRINGS[n3]);
            stringBuilder.append(BYTE_STRINGS[n2]);
        }
        return stringBuilder.toString();
    }

    public static String encodeHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            if (n < 0) {
                n += 256;
            }
            int n2 = (n &= 0xFF) % 16;
            int n3 = n / 16;
            stringBuilder.append(BYTE_STRINGS[n3]);
            stringBuilder.append(BYTE_STRINGS[n2]);
        }
        return stringBuilder.toString();
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    public static String rightJustify(int n, int n2) {
        String string = String.valueOf(n);
        while (string.length() < n2) {
            string = " " + string;
        }
        return string;
    }
}

