/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.ptmp.ConnectionNegotiationProperties;
import apicore.ptmp.LowLevelReadThread;
import apicore.ptmp.OptionsManager;
import apicore.util.Logger;
import apicore.util.Utilities;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class PacketTracerConnection {
    protected String host;
    protected int port;
    protected ConnectionNegotiationProperties connectionNegotiationProperties;
    protected SocketChannel socketChannel;
    protected Selector selector;
    protected int readCount = 0;
    protected int writeCount = 0;
    protected int lowLevelReadErrorCount = 0;
    protected LowLevelReadThread readThread;
    protected Object currentStatus = STATUS_NEW;
    protected String currentStatusReason = "PacketTracerConnection instantiated";
    protected Throwable currentStatusThrowable;
    public static final Object STATUS_CLOSED = "CLOSED";
    public static final Object STATUS_DOWN = "DOWN";
    public static final Object STATUS_NEW = "NEW";
    public static final Object STATUS_UP = "UP";

    protected PacketTracerConnection() {
    }

    public PacketTracerConnection(String string, int n, ConnectionNegotiationProperties connectionNegotiationProperties) {
        Logger.info("Creating PacketTracerConnection instance with host:[" + string + "] port:[" + n + "]");
        this.host = string;
        this.port = n;
        this.connectionNegotiationProperties = connectionNegotiationProperties == null ? OptionsManager.getInstance().getConnectOpts() : connectionNegotiationProperties;
        this.readThread = new LowLevelReadThread(this);
        Logger.info("Connection negotiation properties: [" + connectionNegotiationProperties + "]");
    }

    public boolean connect() {
        try {
            Logger.info("Attempting to open connection to host:[" + this.host + "] port:[" + this.port + "]");
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.host, this.port);
            this.socketChannel = SocketChannel.open(inetSocketAddress);
            this.socketChannel.configureBlocking(false);
            this.selector = Selector.open();
            this.socketChannel.register(this.selector, 1);
            this.setStatus(STATUS_UP, "PacketTracerConnection successfully opened");
            Logger.info("Succesfully connected to host:[" + this.host + "] port:[" + this.port + "]\n\tSocket channel is blocking: [" + this.socketChannel.isBlocking() + "]");
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            this.setStatus(STATUS_DOWN, "Error while attempting to open connection: ", throwable);
        }
        return this.isUp();
    }

    public boolean reconnect() {
        if (!this.isUp()) {
            this.connect();
            if (this.isUp()) {
                this.reconnectLowLevelReadThread();
            }
        }
        return this.isUp();
    }

    public void connectLowLevelReadThread() {
        this.readThread.start();
    }

    public void reconnectLowLevelReadThread() {
        this.connectLowLevelReadThread();
    }

    public void disconnectLowLevelReadThread() {
        this.readThread.shouldStop();
    }

    public void disconnect() {
        try {
            Logger.info("Attempting to close connection to host:[" + this.host + "] port:[" + this.port + "]");
            this.disconnectLowLevelReadThread();
            this.selector.close();
            this.socketChannel.close();
            this.selector = null;
            this.socketChannel = null;
            this.setStatus(STATUS_CLOSED, "PacketTracerConnection closed by request");
            Logger.debug("Succesfully closed connection to host:[" + this.host + "] port:[" + this.port + "]");
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            this.setStatus(STATUS_DOWN, "Error while attempting to close connection: ", throwable);
        }
    }

    public boolean isUp() {
        return this.currentStatus == STATUS_UP;
    }

    public boolean isDown() {
        return !this.isUp();
    }

    public Object getCurrentStatus() {
        return this.currentStatus;
    }

    public String getCurrentStatusReason() {
        return this.currentStatusReason;
    }

    public Throwable getCurrentStatusThrowable() {
        return this.currentStatusThrowable;
    }

    public boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isConnected();
    }

    public boolean isOpen() {
        return this.socketChannel != null && this.socketChannel.isOpen() && this.socketChannel.socket() != null && !this.socketChannel.socket().isClosed() && !this.socketChannel.socket().isInputShutdown() && !this.socketChannel.socket().isOutputShutdown();
    }

    public ByteBuffer getNextMessage() throws Exception {
        return this.readThread.getNextMessage();
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.innerRead(byteBuffer);
        }
        catch (IOException iOException) {
            this.setStatus(STATUS_DOWN, "Error during read: ", iOException);
            throw iOException;
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            this.setStatus(STATUS_DOWN, "Error during read: ", throwable);
            throw new Error("Error during read", throwable);
        }
    }

    protected int innerRead(ByteBuffer byteBuffer) throws IOException {
        int n = -24;
        this.selector.select();
        Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            iterator.remove();
            if (!selectionKey.isValid() || !selectionKey.isReadable()) continue;
            this.incrementReadCount();
            n = this.socketChannel.read(byteBuffer);
        }
        return n;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.innerWrite(byteBuffer);
        }
        catch (IOException iOException) {
            this.setStatus(STATUS_DOWN, "Error during write: ", iOException);
            throw iOException;
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            this.setStatus(STATUS_DOWN, "Error during write: ", throwable);
            throw new Error("Error during read", throwable);
        }
    }

    protected int innerWrite(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            this.incrementWriteCount();
            int n2 = this.socketChannel.write(byteBuffer);
            n += n2;
        }
        return n;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    public ConnectionNegotiationProperties connectionNegotiationProperties() {
        return this.connectionNegotiationProperties;
    }

    public int getLowLevelReadErrorCount() {
        return this.lowLevelReadErrorCount;
    }

    public synchronized void noteLowLevelReadError(Throwable throwable) {
        ++this.lowLevelReadErrorCount;
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    protected synchronized void incrementWriteCount() {
        ++this.writeCount;
    }

    public int getReadCount() {
        return this.readCount;
    }

    protected synchronized void incrementReadCount() {
        ++this.readCount;
    }

    protected void setStatus(Object object, String string) {
        this.currentStatus = object;
        this.currentStatusReason = string;
        this.currentStatusThrowable = null;
    }

    protected void setStatus(Object object, String string, Throwable throwable) {
        this.currentStatus = object;
        this.currentStatusReason = string + throwable.getMessage();
        this.currentStatusThrowable = throwable;
    }
}

