/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu.pdu;

import apicore.mu.pdu.Header;
import apicore.ptmp.PtmpBuffer;

public class LLCHeader
extends Header {
    public byte dsap = 0;
    public byte ssap = 0;
    public String control = "";
    public String info = "";
    public int length = 0;

    public void serialize(PtmpBuffer ptmpBuffer) {
        super.serialize(ptmpBuffer);
        ptmpBuffer.putByte(this.dsap);
        ptmpBuffer.putByte(this.ssap);
        ptmpBuffer.putString(this.control);
        ptmpBuffer.putString(this.info);
        ptmpBuffer.putInt(this.length);
    }

    public boolean deserialize(PtmpBuffer ptmpBuffer) {
        if (!super.deserialize(ptmpBuffer)) {
            return false;
        }
        try {
            this.dsap = ptmpBuffer.getByte();
            this.ssap = ptmpBuffer.getByte();
            this.control = ptmpBuffer.getString();
            this.info = ptmpBuffer.getString();
            this.length = ptmpBuffer.getInt();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static LLCHeader create(PtmpBuffer ptmpBuffer) {
        LLCHeader lLCHeader = new LLCHeader();
        if (lLCHeader.deserialize(ptmpBuffer)) {
            return lLCHeader;
        }
        return null;
    }

    public String getTypeName() {
        return "CLLCHeader";
    }

    public String toString() {
        String string = "";
        string = string + "[LLCHeader: dsap=" + this.dsap + ", ssap=" + this.ssap + ", control=" + this.control + ", info=" + this.info + ", length=" + this.length + "]";
        string = string + super.toString();
        return string;
    }
}

