/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu.pdu;

import apicore.mu.pdu.Header;
import apicore.ptmp.PtmpBuffer;

public class IcmpMessage
extends Header {
    public byte type = 0;
    public byte code = 0;
    public short checksum = 0;
    public short id = 0;
    public short seqnum = 0;

    public void serialize(PtmpBuffer ptmpBuffer) {
        super.serialize(ptmpBuffer);
        ptmpBuffer.putByte(this.type);
        ptmpBuffer.putByte(this.code);
        ptmpBuffer.putShort(this.checksum);
        ptmpBuffer.putShort(this.id);
        ptmpBuffer.putShort(this.seqnum);
    }

    public boolean deserialize(PtmpBuffer ptmpBuffer) {
        if (!super.deserialize(ptmpBuffer)) {
            return false;
        }
        try {
            this.type = ptmpBuffer.getByte();
            this.code = ptmpBuffer.getByte();
            this.checksum = ptmpBuffer.getShort();
            this.id = ptmpBuffer.getShort();
            this.seqnum = ptmpBuffer.getShort();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static IcmpMessage create(PtmpBuffer ptmpBuffer) {
        IcmpMessage icmpMessage = new IcmpMessage();
        if (icmpMessage.deserialize(ptmpBuffer)) {
            return icmpMessage;
        }
        return null;
    }

    public String getTypeName() {
        return "CIcmpMessage";
    }

    public String toString() {
        String string = "";
        string = string + "[IcmpMessage: ";
        string = string + "type=" + this.type + ", ";
        string = string + "code=" + this.code + ", ";
        string = string + "checksum=" + this.checksum + ", ";
        string = string + "id=" + this.id + ", ";
        string = string + "seqnum=" + this.seqnum + "";
        string = string + "]";
        return string;
    }
}

