/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu.pdu;

import apicore.message.MACAddress;
import apicore.mu.pdu.Header;
import apicore.ptmp.PtmpBuffer;

public class EthernetHeader
extends Header {
    public MACAddress src = null;
    public MACAddress dst = null;
    public int fcs = 0;

    public static EthernetHeader create(PtmpBuffer ptmpBuffer) {
        EthernetHeader ethernetHeader = new EthernetHeader();
        if (ethernetHeader.deserialize(ptmpBuffer)) {
            return ethernetHeader;
        }
        return null;
    }

    public void serialize(PtmpBuffer ptmpBuffer) {
        super.serialize(ptmpBuffer);
        ptmpBuffer.putMACAddress(this.src);
        ptmpBuffer.putMACAddress(this.dst);
        ptmpBuffer.putInt(this.fcs);
    }

    public boolean deserialize(PtmpBuffer ptmpBuffer) {
        if (!super.deserialize(ptmpBuffer)) {
            return false;
        }
        try {
            this.src = ptmpBuffer.getMACAddress();
            this.dst = ptmpBuffer.getMACAddress();
            this.fcs = ptmpBuffer.getInt();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public String getTypeName() {
        return "CEthernetHeader";
    }

    public String toString() {
        String string = "";
        string = string + "[Ethernet: src=" + this.src + ", dst=" + this.dst + ", fcs=" + this.fcs + "]";
        string = string + super.toString();
        return string;
    }
}

