/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu.pdu;

import apicore.mu.pdu.CdpTlv;
import apicore.mu.pdu.PDU;
import apicore.ptmp.PtmpBuffer;
import java.util.ArrayList;

public class CdpFrame
extends PDU {
    public byte version = 0;
    public byte holdTime = 0;
    public short checksum = 0;
    public ArrayList<CdpTlv> tlvs = new ArrayList();

    public void serialize(PtmpBuffer ptmpBuffer) {
        super.serialize(ptmpBuffer);
        ptmpBuffer.putByte(this.version);
        ptmpBuffer.putByte(this.holdTime);
        ptmpBuffer.putShort(this.checksum);
        ptmpBuffer.putInt(this.tlvs.size());
        for (int i = 0; i < this.tlvs.size(); ++i) {
            CdpTlv cdpTlv = this.tlvs.get(i);
            cdpTlv.serialize(ptmpBuffer);
        }
    }

    public boolean deserialize(PtmpBuffer ptmpBuffer) {
        if (!super.deserialize(ptmpBuffer)) {
            return false;
        }
        try {
            this.version = (byte)(0xFF & ptmpBuffer.getByte());
            this.holdTime = (byte)(0xFF & ptmpBuffer.getByte());
            this.checksum = (short)(0xFFFF & ptmpBuffer.getShort());
            int n = ptmpBuffer.getInt();
            this.tlvs = new ArrayList();
            for (int i = 0; i < n; ++i) {
                CdpTlv cdpTlv = CdpTlv.create(ptmpBuffer);
                if (cdpTlv == null) {
                    return false;
                }
                this.tlvs.add(cdpTlv);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static CdpFrame create(PtmpBuffer ptmpBuffer) {
        CdpFrame cdpFrame = new CdpFrame();
        if (cdpFrame.deserialize(ptmpBuffer)) {
            return cdpFrame;
        }
        return null;
    }

    public String getTypeName() {
        return "CCdpFrame";
    }

    public String toString() {
        String string = "";
        string = string + super.toString() + "[CdpFrame: version=" + this.version + ", holdTime=" + this.holdTime + ", checksum=" + this.checksum + "]";
        for (int i = 0; i < this.tlvs.size(); ++i) {
            string = string + this.tlvs.get(i).toString();
        }
        return string;
    }
}

