/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu.pdu;

import apicore.mu.pdu.PDU;
import apicore.ptmp.PtmpBuffer;

public class CdpAddressData
extends PDU {
    public byte protoType = 0;
    public byte protoLength = 0;
    public byte protocol = 0;
    public short addressLength = 0;
    public String address = "";

    public void serialize(PtmpBuffer ptmpBuffer) {
        super.serialize(ptmpBuffer);
        ptmpBuffer.putByte(this.protoType);
        ptmpBuffer.putByte(this.protoLength);
        ptmpBuffer.putByte(this.protocol);
        ptmpBuffer.putShort(this.addressLength);
        ptmpBuffer.putString(this.address);
    }

    public boolean deserialize(PtmpBuffer ptmpBuffer) {
        if (!super.deserialize(ptmpBuffer)) {
            return false;
        }
        try {
            this.protoType = ptmpBuffer.getByte();
            this.protoLength = ptmpBuffer.getByte();
            this.protocol = ptmpBuffer.getByte();
            this.addressLength = ptmpBuffer.getShort();
            this.address = ptmpBuffer.getString();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static CdpAddressData create(PtmpBuffer ptmpBuffer) {
        CdpAddressData cdpAddressData = new CdpAddressData();
        if (cdpAddressData.deserialize(ptmpBuffer)) {
            return cdpAddressData;
        }
        return null;
    }

    public String getTypeName() {
        return "CCdpAddressPacket";
    }

    public String toString() {
        String string = "";
        string = string + super.toString() + "[Address: protoType=" + this.protoType + ", protoLength=" + this.protoLength + ", protocol=" + this.protocol + ", addressLength=" + this.addressLength + ", address=" + this.address + "]";
        return string;
    }
}

