/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu.pdu;

import apicore.mu.pdu.CdpAddressData;
import apicore.mu.pdu.CdpTlv;
import apicore.ptmp.PtmpBuffer;
import java.util.ArrayList;

public class CdpAddress
extends CdpTlv {
    public int numAddresses = 0;
    public ArrayList<CdpAddressData> addresses = new ArrayList();

    public void serialize(PtmpBuffer ptmpBuffer) {
        super.serialize(ptmpBuffer);
        ptmpBuffer.putInt(this.numAddresses);
        ptmpBuffer.putInt(this.addresses.size());
        for (int i = 0; i < this.addresses.size(); ++i) {
            CdpAddressData cdpAddressData = this.addresses.get(i);
            cdpAddressData.serialize(ptmpBuffer);
        }
    }

    public boolean deserialize(PtmpBuffer ptmpBuffer) {
        if (!super.deserialize(ptmpBuffer)) {
            return false;
        }
        try {
            this.numAddresses = ptmpBuffer.getInt();
            int n = ptmpBuffer.getInt();
            this.addresses = new ArrayList();
            for (int i = 0; i < n; ++i) {
                String string = ptmpBuffer.getString();
                if (!string.equals("CCdpAddressPacket")) continue;
                CdpAddressData cdpAddressData = CdpAddressData.create(ptmpBuffer);
                if (cdpAddressData == null) {
                    return false;
                }
                this.addresses.add(cdpAddressData);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static CdpAddress create(PtmpBuffer ptmpBuffer) {
        CdpAddress cdpAddress = new CdpAddress();
        if (cdpAddress.deserialize(ptmpBuffer)) {
            return cdpAddress;
        }
        return null;
    }

    public String getTypeName() {
        return "CCdpAddress";
    }

    public String toString() {
        String string = "";
        string = string + "[CdpAddress: " + super.toString() + ", numAddresses=" + this.numAddresses;
        for (int i = 0; i < this.addresses.size(); ++i) {
            string = string + ", " + this.addresses.get(i).toString();
        }
        string = string + "]";
        return string;
    }
}

