/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu.pdu;

import apicore.message.IPAddress;
import apicore.message.MACAddress;
import apicore.mu.pdu.PDU;
import apicore.ptmp.PtmpBuffer;

public class ArpPacket
extends PDU {
    public short hardware_type = 0;
    public short proto_type = 0;
    public byte hardware_len = 0;
    public byte proto_len = 0;
    public short opcode = 0;
    public MACAddress src_mac = null;
    public MACAddress dst_mac = null;
    public IPAddress src_ip = null;
    public IPAddress dst_ip = null;

    public void serialize(PtmpBuffer ptmpBuffer) {
        super.serialize(ptmpBuffer);
        ptmpBuffer.putShort(this.hardware_type);
        ptmpBuffer.putShort(this.proto_type);
        ptmpBuffer.putByte(this.hardware_len);
        ptmpBuffer.putByte(this.proto_len);
        ptmpBuffer.putShort(this.opcode);
        ptmpBuffer.putMACAddress(this.src_mac);
        ptmpBuffer.putMACAddress(this.dst_mac);
        ptmpBuffer.putIPAddress(this.src_ip);
        ptmpBuffer.putIPAddress(this.dst_ip);
    }

    public boolean deserialize(PtmpBuffer ptmpBuffer) {
        if (!super.deserialize(ptmpBuffer)) {
            return false;
        }
        try {
            this.hardware_type = ptmpBuffer.getShort();
            this.proto_type = ptmpBuffer.getShort();
            this.hardware_len = ptmpBuffer.getByte();
            this.proto_len = ptmpBuffer.getByte();
            this.opcode = ptmpBuffer.getShort();
            this.src_mac = ptmpBuffer.getMACAddress();
            this.dst_mac = ptmpBuffer.getMACAddress();
            this.src_ip = ptmpBuffer.getIPAddress();
            this.dst_ip = ptmpBuffer.getIPAddress();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static ArpPacket create(PtmpBuffer ptmpBuffer) {
        ArpPacket arpPacket = new ArpPacket();
        if (arpPacket.deserialize(ptmpBuffer)) {
            return arpPacket;
        }
        return null;
    }

    public String getTypeName() {
        return "CArpPacket";
    }

    public String toString() {
        String string = "";
        string = string + "[ArpPacket: ";
        string = string + "hardware_type=" + this.hardware_type + ", ";
        string = string + "proto_type=" + this.proto_type + ", ";
        string = string + "hardware_len=" + this.hardware_len + ", ";
        string = string + "proto_len=" + this.proto_len + ", ";
        string = string + "opcode=" + this.opcode + ", ";
        string = string + "src_mac=" + this.src_mac + ", ";
        string = string + "dst_mac=" + this.dst_mac + ", ";
        string = string + "src_ip=" + this.src_ip + ", ";
        string = string + "dst_ip=" + this.dst_ip + "";
        string = string + "]";
        return string;
    }
}

