/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu;

import apicore.message.UUID;
import apicore.mu.MultiUserMessage;
import apicore.mu.PTSaveInfo;
import apicore.ptmp.EncodedBuffer;
import java.util.ArrayList;

public class MUSaveNetReqMessage
extends MultiUserMessage {
    public UUID saveReqId = new UUID("{00000000-0000-0000-0000-000000000000}");
    public UUID requestorId = new UUID("{00000000-0000-0000-0000-000000000000}");
    public int depthInfo = 0;
    public int timeoutInfo = 0;
    public int saveOrder = 0;
    public String clusterId = "";
    public ArrayList<PTSaveInfo> fullySaved = new ArrayList();
    public ArrayList<PTSaveInfo> partiallySaved = new ArrayList();

    public MUSaveNetReqMessage() {
        super.setType(PTMP_TYPE_MUSAVENETREQ);
    }

    public static MUSaveNetReqMessage getMessage(EncodedBuffer encodedBuffer) {
        int n;
        MUSaveNetReqMessage mUSaveNetReqMessage = new MUSaveNetReqMessage();
        mUSaveNetReqMessage.saveReqId = encodedBuffer.getUUID();
        mUSaveNetReqMessage.requestorId = encodedBuffer.getUUID();
        mUSaveNetReqMessage.depthInfo = encodedBuffer.getInt();
        mUSaveNetReqMessage.timeoutInfo = encodedBuffer.getInt();
        mUSaveNetReqMessage.saveOrder = encodedBuffer.getInt();
        mUSaveNetReqMessage.clusterId = encodedBuffer.getString();
        int n2 = encodedBuffer.getInt();
        for (n = 0; n < n2; ++n) {
            mUSaveNetReqMessage.fullySaved.get((int)n).ptid = encodedBuffer.getUUID();
        }
        n = encodedBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            UUID uUID = encodedBuffer.getUUID();
            String string = encodedBuffer.getString();
            int n3 = encodedBuffer.getInt();
            mUSaveNetReqMessage.partiallySaved.set(i, new PTSaveInfo(uUID, string, n3));
        }
        return mUSaveNetReqMessage;
    }

    public void encodeTypeAndPayload(EncodedBuffer encodedBuffer) {
        int n;
        encodedBuffer.putInt(super.getType());
        encodedBuffer.putUUID(this.saveReqId);
        encodedBuffer.putUUID(this.requestorId);
        encodedBuffer.putInt(this.depthInfo);
        encodedBuffer.putInt(this.timeoutInfo);
        encodedBuffer.putInt(this.saveOrder);
        encodedBuffer.putString(this.clusterId);
        encodedBuffer.putInt(this.fullySaved.size());
        for (n = 0; n < this.fullySaved.size(); ++n) {
            encodedBuffer.putUUID(this.fullySaved.get((int)n).ptid);
        }
        encodedBuffer.putInt(this.partiallySaved.size());
        for (n = 0; n < this.partiallySaved.size(); ++n) {
            encodedBuffer.putUUID(this.partiallySaved.get((int)n).ptid);
            encodedBuffer.putString(this.partiallySaved.get((int)n).clusterId);
            encodedBuffer.putInt(this.partiallySaved.get((int)n).depthLeft);
        }
        encodedBuffer.flip();
    }

    public String toString() {
        String string = new String();
        string = "[MUSaveNetReqMessage: \n";
        string = string + "        saveReqId: " + this.saveReqId + "\n";
        string = string + "      requestorId: " + this.requestorId + "\n";
        string = string + "        depthInfo: " + this.depthInfo + "\n";
        string = string + "      timeoutInfo: " + this.timeoutInfo + "\n";
        string = string + "        saveOrder: " + this.saveOrder + "\n";
        string = string + "        clusterId: " + this.clusterId + "\n";
        string = string + "]";
        return string;
    }
}

