/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu;

import apicore.mu.MultiUserMessage;
import apicore.mu.pdu.PDU;
import apicore.ptmp.EncodedBuffer;

public class MUPDUMessage
extends MultiUserMessage {
    public int msgId = -1;
    public int linkId = -1;
    public PDU pdu = null;

    public MUPDUMessage() {
        super.setType(PTMP_TYPE_MUPDU);
    }

    public static MUPDUMessage getMessage(EncodedBuffer encodedBuffer) {
        MUPDUMessage mUPDUMessage = new MUPDUMessage();
        mUPDUMessage.msgId = encodedBuffer.getInt();
        mUPDUMessage.linkId = encodedBuffer.getInt();
        mUPDUMessage.pdu = PDU.create(encodedBuffer);
        return mUPDUMessage;
    }

    public void encodeTypeAndPayload(EncodedBuffer encodedBuffer) {
        encodedBuffer.putInt(super.getType());
        encodedBuffer.putInt(this.msgId);
        encodedBuffer.putInt(this.linkId);
        if (this.pdu != null) {
            this.pdu.serialize(encodedBuffer);
        }
        encodedBuffer.flip();
    }

    public String toString() {
        String string = new String();
        string = "[MUPDUMessage: \n";
        string = string + "    msgId: " + this.msgId + "\n";
        string = string + "   linkId: " + this.linkId + "\n";
        string = string + "      pdu: " + this.pdu + "\n";
        string = string + "]";
        return string;
    }
}

