/*
 * Decompiled with CFR 0.152.
 */
package apicore.message;

import apicore.util.Utilities;
import java.util.Arrays;

public class UUID {
    public static final int UUID_BYTES = 16;
    byte[] bytes = new byte[16];

    public UUID(byte[] byArray) {
        this.setBytes(this.bytes);
    }

    public UUID(String string) {
        if (string == null) {
            return;
        }
        this.setBytes(Utilities.decodeHex(string));
    }

    protected void setBytes(byte[] byArray) {
        Arrays.fill(this.bytes, (byte)0);
        int n = byArray.length >= this.bytes.length ? 0 : this.bytes.length - byArray.length;
        int n2 = Math.min(this.bytes.length, byArray.length);
        for (int i = 0; i < n2; ++i) {
            this.bytes[n + i] = byArray[i];
        }
    }

    public String toString() {
        return this.getDecoratedHexString();
    }

    public String getDecoratedHexString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Utilities.encodeHex(this.bytes);
        char[] cArray = string.toCharArray();
        if (cArray.length == 32) {
            stringBuffer.append("{");
            stringBuffer.append(cArray, 0, 8);
            stringBuffer.append('-');
            stringBuffer.append(cArray, 8, 4);
            stringBuffer.append('-');
            stringBuffer.append(cArray, 12, 4);
            stringBuffer.append('-');
            stringBuffer.append(cArray, 16, 4);
            stringBuffer.append('-');
            stringBuffer.append(cArray, 20, 12);
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    public byte[] getByteArrayValue() {
        return this.bytes;
    }

    public static UUID makeRandom() {
        byte[] byArray = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray[i] = (byte)Math.floor((byte)Math.random() * 255);
        }
        UUID uUID = new UUID(byArray);
        return uUID;
    }
}

