/*
 * Decompiled with CFR 0.152.
 */
package apicore.message;

import apicore.message.LTVParsingError;
import apicore.util.Utilities;
import java.util.Arrays;

public class MACAddress {
    private static final int HEX_RADIX = 16;
    public static final int MACADDRESS_BYTES = 6;
    byte[] bytes = new byte[6];

    public MACAddress(byte[] byArray) {
        this.setBytes(byArray);
    }

    public MACAddress(String string) {
        this.setBytes(Utilities.decodeHex(string));
    }

    protected void setBytes(byte[] byArray) {
        Arrays.fill(this.bytes, (byte)0);
        int n = byArray.length >= this.bytes.length ? 0 : this.bytes.length - byArray.length;
        int n2 = Math.min(this.bytes.length, byArray.length);
        for (int i = 0; i < n2; ++i) {
            this.bytes[n + i] = byArray[i];
        }
    }

    public String getDottedHexString() {
        return Utilities.encodeDottedHex(this.bytes);
    }

    public String getHexString() {
        return Utilities.encodeHex(this.bytes);
    }

    public static MACAddress parseMACAddress(String string) {
        MACAddress mACAddress = null;
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 3) {
            throw new LTVParsingError("Invalid format for MAC Address: " + string);
        }
        try {
            byte[] byArray = new byte[6];
            for (int i = 0; i < stringArray.length; ++i) {
                int n = Integer.parseInt(stringArray[i], 16);
                byArray[2 * i] = (byte)(n >> 8 & 0xFF);
                byArray[2 * i + 1] = (byte)(n & 0xFF);
            }
            mACAddress = new MACAddress(byArray);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LTVParsingError("Invalid format for MAC Address: " + string);
        }
        return mACAddress;
    }

    public byte[] getByteArrayValue() {
        return this.bytes;
    }
}

