/*
 * Decompiled with CFR 0.152.
 */
package apicore.message;

import apicore.message.LTV;
import apicore.ptmp.EncodedBuffer;

public class IPCMessageLTV
extends LTV {
    protected int messageId;
    protected String message;

    public IPCMessageLTV(String string) {
        this.setType(100);
        this.messageId = LTV.getNextMessageId();
        this.message = string;
    }

    public boolean hasResponse() {
        return true;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public String getMessage() {
        return this.message;
    }

    public void encodeTypeAndPayload(EncodedBuffer encodedBuffer) {
        encodedBuffer.putInt(this.getType());
        encodedBuffer.putInt(this.messageId);
        this.encodeIpcCalls(encodedBuffer, this.message);
    }

    protected void encodeIpcCalls(EncodedBuffer encodedBuffer, String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        try {
            int n = string.indexOf("(");
            int n2 = string.indexOf(")");
            int n3 = string.indexOf(".", n2);
            if (n < 0 || n2 <= n) {
                throw new Error("Error parsing IPC Message: <" + string + ">");
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, n2);
            encodedBuffer.putString(string2);
            this.encodeParameters(encodedBuffer, string3);
            encodedBuffer.putByte((byte)0);
            if (n3 >= 0) {
                this.encodeIpcCalls(encodedBuffer, string.substring(n3 + 1));
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new Error("Error encoding IPC Message: <" + string + ">");
        }
    }

    protected void encodeParameters(EncodedBuffer encodedBuffer, String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        try {
            int n = string.indexOf(":");
            if (n < 0) {
                throw new Error("Error parsing IPC Parameter: <" + string + ">");
            }
            int n2 = string.indexOf(",");
            if (n2 < 0) {
                n2 = string.length();
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, n2);
            this.encodeTypeAndValue(encodedBuffer, string2, string3);
            if (n2 < string.length()) {
                this.encodeParameters(encodedBuffer, string.substring(n2 + 1));
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new Error("Error encoding IPC Parameter: <" + string + ">");
        }
    }

    protected void encodeTypeAndValue(EncodedBuffer encodedBuffer, String string, String string2) {
        if (string.equalsIgnoreCase("boolean")) {
            boolean bl = Boolean.parseBoolean(string2);
            encodedBuffer.putByte((byte)2);
            encodedBuffer.putBool(bl);
        } else if (string.equalsIgnoreCase("byte")) {
            byte by = Byte.parseByte(string2);
            encodedBuffer.putByte((byte)1);
            encodedBuffer.putByte(by);
        } else if (string.equalsIgnoreCase("int")) {
            int n = Integer.parseInt(string2);
            encodedBuffer.putByte((byte)4);
            encodedBuffer.putInt(n);
        } else if (string.equalsIgnoreCase("qstring")) {
            encodedBuffer.putByte((byte)9);
            encodedBuffer.putString(string2);
        } else if (string.equalsIgnoreCase("string")) {
            encodedBuffer.putByte((byte)8);
            encodedBuffer.putString(string2);
        } else {
            throw new Error("Invalid type for encoding: <" + string + ">");
        }
    }
}

