/*
 * Decompiled with CFR 0.152.
 */
package apicore.message;

import apicore.message.LTVParsingError;
import apicore.util.Logger;
import apicore.util.Utilities;
import java.util.Arrays;

public class IPAddress {
    public static final int IPADDRESS_BYTES = 4;
    byte[] bytes = new byte[4];

    public IPAddress(byte by, byte by2, byte by3, byte by4) {
        this.bytes[0] = by;
        this.bytes[1] = by2;
        this.bytes[2] = by3;
        this.bytes[3] = by4;
    }

    public IPAddress(byte[] byArray) {
        this.setBytes(byArray);
    }

    public IPAddress(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 4) {
            Logger.error("Invalid format for IP Address: " + string);
            return;
        }
        try {
            for (int i = 0; i < 4; ++i) {
                int n = Integer.parseInt(stringArray[i]);
                this.bytes[i] = (byte)(n & 0xFF);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logger.error("Invalid format for IP Address: " + string);
        }
    }

    protected void setBytes(byte[] byArray) {
        Arrays.fill(this.bytes, (byte)0);
        int n = byArray.length >= this.bytes.length ? 0 : this.bytes.length - byArray.length;
        int n2 = Math.min(this.bytes.length, byArray.length);
        for (int i = 0; i < n2; ++i) {
            this.bytes[n + i] = byArray[i];
        }
    }

    public String toString() {
        return this.getDottedQuadString();
    }

    public String getDottedQuadString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (i > 0) {
                stringBuilder.append('.');
            }
            int n = this.bytes[i] & 0xFF;
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    public String getHexString() {
        return Utilities.encodeHex(this.bytes);
    }

    public byte[] getByteArrayValue() {
        return this.bytes;
    }

    public int getIntValue() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n <<= 8;
            n |= this.bytes[i] & 0xFF;
        }
        return n;
    }

    protected String toHex(byte by) {
        String string = Integer.toHexString(by);
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    public static IPAddress parseIPAddress(String string) {
        IPAddress iPAddress = null;
        int[] nArray = new int[4];
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 4) {
            throw new LTVParsingError("Invalid format for IP Address: " + string);
        }
        try {
            for (int i = 0; i < 4; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            iPAddress = new IPAddress((byte)nArray[0], (byte)nArray[1], (byte)nArray[2], (byte)nArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LTVParsingError("Invalid format for IP Address: " + string);
        }
        return iPAddress;
    }
}

