#include <stdio.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <time.h>

#define SHMOBJ_PATH         "/example"
#define MAX_MSG_LENGTH      50
#define TYPES               8  

/* üzenet struktúra */
struct msg_s {
	int type;
	char content[MAX_MSG_LENGTH];
};

int main(int argc, char *argv[]) 
{
	int shmfd;
	int shared_seg_size = (sizeof(struct msg_s));   /* megosztott szegmens mérete (jelen esetben egyetlen struktúrát fogunk megosztani)*/
	struct msg_s *shared_msg;                   

	shmfd = shm_open(SHMOBJ_PATH, O_CREAT | O_EXCL | O_RDWR, S_IRWXU | S_IRWXG);  /* memória objektum létrehozása */
	if (shmfd < 0) {
		perror("In shm_open()");
		exit(1);
	}

	printf("Created shared memory object %s\n", SHMOBJ_PATH);
	ftruncate(shmfd, shared_seg_size);      /* méret beállítása, hogy férjen el az egész struktúra */
        /* struktúra megosztása */   
	shared_msg = (struct msg_s *)mmap(NULL, shared_seg_size, PROT_READ | PROT_WRITE, MAP_SHARED, shmfd, 0);
    	if (shared_msg == NULL) {
        	perror("In mmap()");
	        exit(1);
	}

	printf("Shared memory segment allocated correctly (%d bytes).\n", shared_seg_size);
	
	srandom(time(NULL));
	shared_msg->type = random() % TYPES;    /* osztott memória tartalmának megváltoztatása */
	int tmp = shared_msg->type;
	snprintf(shared_msg->content, MAX_MSG_LENGTH, "My message, type %d, num %ld", shared_msg->type, random());

	printf("waiting...\n");
	/* várakozás amíg a kliens át nem írja a típust -1 re. A foglalva várakozás nem a legjobb megoldás, de jelen esetben az egyszerűség kedvéért ez is megfelel */

	while (shared_msg->type==tmp) { };
	printf("type = %d\n ",shared_msg->type);
	
	if (munmap(shared_msg,shared_seg_size)==-1){
		perror("munmap:");
		exit(1);
	}

	printf("Munmap: succes\nclose\n");

	if (shm_unlink(SHMOBJ_PATH) != 0) {   /* lekapcsolódás az osztott memóriáról*/
        	perror("In shm_unlink()");
        	exit(1);
   	}

    	return 0;
}
